<?php

/**
 * FanPress CM 5.x
 * @license http://www.gnu.org/licenses/gpl.txt GPLv3
 */

namespace fpcm\model\dashboard;

/**
 * Recent comments dashboard container object
 * 
 * @package fpcm\model\dashboard
 * @author Stefan Seehafer aka imagine <fanpress@nobody-knows.org>
 * @copyright (c) 2011-2022, Stefan Seehafer
 * @license http://www.gnu.org/licenses/gpl.txt GPLv3
 */
class recentcomments extends \fpcm\model\abstracts\dashcontainer implements \fpcm\model\interfaces\isAccessible {

    /**
     * Permissions-Objekt
     * @var \fpcm\model\permissions\permissions
     */
    protected $permissions = null;

    /**
     * aktueller Benutzer
     * @var int
     */
    protected $currentUser = 0;

    /**
     * Benutzer ist Admin
     * @see \fpcm\model\abstracts\dashcontainer
     * @var int
     */
    protected $isAdmin = false;

    /**
     * Container is accessible
     * @return bool
     */
    public function isAccessible(): bool
    {
        return $this->config->system_comments_enabled && $this->permissions->editComments();
    }

    /**
     * Returns container name
     * @return string
     */
    public function getName()
    {
        return 'recentcomments';
    }

    /**
     * Returns container content
     * @return string
     */
    public function getContent()
    {
        $session = \fpcm\classes\loader::getObject('\fpcm\model\system\session');
        $this->currentUser = $session->getUserId();
        $this->isAdmin = $session->getCurrentUser()->isAdmin();

        $this->getCacheName('_' . $this->currentUser);

        if (!$this->cache->isExpired($this->cacheName)) {
            return $this->cache->read($this->cacheName);
        }

        $commenList = new \fpcm\model\comments\commentList();

        $search = new \fpcm\model\comments\search();
        $search->searchtype = 0;
        $search->deleted = 0;
        $search->limit = array(10, 0);
        $search->orderby = array('createtime DESC');

        $comments = $commenList->getCommentsBySearchCondition($search);
        
        if (!count($comments)) {
            $str = $this->language->translate('GLOBAL_NOTFOUND2');
            $this->cache->write($this->cacheName, $str);
            return $str;
        }

        $userlist = new \fpcm\model\users\userList();
        $users = array_flip($userlist->getUsersNameList());

        $createStr = $this->language->translate('GLOBAL_LASTCHANGE');
        
        $content = [];
        $content[] = '<div>';
        foreach ($comments as $comment) {

            $createInfo = $this->language->translate('GLOBAL_USER_ON_TIME', array(
                '{{username}}' => isset($users[$comment->getChangeuser()]) ? $users[$comment->getChangeuser()] : $this->language->translate('GLOBAL_NOTFOUND'),
                '{{time}}' => date($this->config->system_dtmask, $comment->getChangetime())
            ));

            if (!$comment->getChangeuser() && !$comment->getChangetime()) {
                $createInfo = '';
            }

            $content[] = '<div class="row fpcm-ui-font-small py-1">';
            $content[] = '  <div class="col-12 col-md-auto px-3 text-center">';
            $content[] = (string) (new \fpcm\view\helper\openButton('openBtn'))->setUrlbyObject($comment)->setTarget(\fpcm\view\helper\linkButton::TARGET_NEW);
            $content[] = (string) (new \fpcm\view\helper\editButton('editBtn'))->setUrlbyObject($comment, '&mode=1')->setReadonly($comment->getEditPermission() ? false : true);
            $content[] = '  </div>';

            $content[] = '  <div class="col align-self-center">';
            $content[] = '  <div class="fpcm-ui-ellipsis">';
            $content[] = '  <strong>' . (new \fpcm\view\helper\escape(strip_tags($comment->getName()))) . '</strong> @ ' . (new \fpcm\view\helper\dateText($comment->getCreatetime())) . '<br>';
            $content[] = '  <span>' . $createStr . ': ' . $createInfo . '</span>';
            $content[] = '  </div></div>';
            $content[] = '  <div class="col-auto fpcm-ui-metabox px-4 align-self-center">';

            $content[] = $comment->getStatusIconSpam();
            $content[] = $comment->getStatusIconApproved();
            $content[] = $comment->getStatusIconPrivate();

            $content[] = '  </div>';
            $content[] = '</div>';
        }

        $content[] = '</div>';

        $str = implode(PHP_EOL, $content);
        $this->cache->write($this->cacheName, $str, $this->config->system_cache_timeout);
        return $str;
    }

    /**
     * Return container headline
     * @return string
     */
    public function getHeadline()
    {
        return 'RECENT_COMMENTS';
    }

    /**
     * Returns container position
     * @return int
     */
    public function getPosition()
    {
        return 4;
    }

    /**
     * Returns container width
     * @return int
     */
    public function getWidth()
    {
        return 8;
    }

    /**
     * Content rendern
     */
    private function renderContent()
    {

    }

    /**
     * Return button object
     * @return \fpcm\view\helper\linkButton|null
     * @since 5.0.0-b3
     */
    public function getButton(): ?\fpcm\view\helper\linkButton
    {
        return (new \fpcm\view\helper\linkButton('toCommentList'))
                ->setUrl(\fpcm\classes\tools::getFullControllerLink('comments/list'))
                ->setIcon('comments', 'far')
                ->setText('HL_COMMENTS_MNG');
    }

}
