<?php

/**
 * FanPress CM language variables file: en
 * @author Stefan Seehafer <sea75300@yahoo.de>
 * @copyright (c) 2011-2022, Stefan Seehafer
 * @license http://www.gnu.org/licenses/gpl.txt GPLv3
 */

$lang = array (
  'AJAX_REQUEST_ERROR' => 'An error occurred while executing the action! You can find more information in the JavaScript log of your browser.',
  'AJAX_RESPONSE_ERROR' => 'An invalid response was returned by the server! You can find more information in the JavaScript log of your browser and possibly in the PHP log.',
  'ARTICLELIST_ERROR' => 'The list could not be loaded because an error occurred while retrieving the data.',
  'ARTICLES_CACHE_CLEAR' => 'Clean article cache',
  'ARTICLES_EDITOR' => 'Article editor',
  'ARTICLES_PUBLIC_ACTIVE' => 'to current articles',
  'ARTICLES_PUBLIC_ARCHIVE' => 'Open archive',
  'ARTICLES_PUBLIC_READMORE' => 'read more',
  'ARTICLES_SEARCH' => 'Search filter',
  'ARTICLES_TRASH' => 'Trash',
  'ARTICLE_LIST_COMMENTNOTICE' => 'Article has unapproved or private comments',
  'ARTICLE_LIST_EMPTYTRASH' => 'Clean trash',
  'ARTICLE_LIST_NEWTWEET' => 'Create new tweet',
  'ARTICLE_LIST_RESTOREARTICLE' => 'Restore elements',
  'ARTICLE_LIST_TITLE' => 'Title',
  'ARTICLE_SEARCH_APPROVAL' => 'Articles to be approved',
  'ARTICLE_SEARCH_CATEGORY' => 'Limit to category',
  'ARTICLE_SEARCH_COMMENTS' => 'Comments active',
  'ARTICLE_SEARCH_DATE_FROM' => 'Date from',
  'ARTICLE_SEARCH_DATE_TO' => 'Date to',
  'ARTICLE_SEARCH_DRAFT' => 'Drafts',
  'ARTICLE_SEARCH_LOGIC' => 'Linkage',
  'ARTICLE_SEARCH_LOGICAND' => 'AND',
  'ARTICLE_SEARCH_LOGICNONE' => 'none',
  'ARTICLE_SEARCH_LOGICOR' => 'OR',
  'ARTICLE_SEARCH_PINNED' => 'Pinned articles',
  'ARTICLE_SEARCH_POSTPONED' => 'Postpined articles',
  'ARTICLE_SEARCH_START' => 'Start search...',
  'ARTICLE_SEARCH_TEXT' => 'Search for this text',
  'ARTICLE_SEARCH_TYPE_ALL' => 'Title AND text',
  'ARTICLE_SEARCH_TYPE_ALLOR' => 'Title OR text',
  'ARTICLE_SEARCH_TYPE_TEXT' => 'Text only',
  'ARTICLE_SEARCH_TYPE_TITLE' => 'Title only',
  'ARTICLE_SEARCH_USER' => 'Limit by user',
  'BACKUPS_NOTICE_POSTGRES' => 'The automatic backup of the database Postgres is currently not supported.',
  'CACHE_CLEARED_OK' => 'The cache has been cleared!',
  'CATEGORIES_ADD' => 'Add category',
  'CATEGORIES_EDIT' => 'Edit category',
  'CATEGORIES_ICON_PATH' => 'Category icon',
  'CATEGORIES_NAME' => 'Category name',
  'CATEGORIES_ROLLS' => 'Available for rolls',
  'COMMENTS_EDIT' => 'Edit comment',
  'COMMENTS_EDITARTICLE' => 'Edit related article',
  'COMMENTS_NOTIFICATION_NEW_COUNT' => 'There are %s new comments.',
  'COMMENTS_PUBLIC_FORMHEADLINE' => 'Leave a comment',
  'COMMENTS_SEARCH_TYPE_ALL' => 'All AND',
  'COMMENTS_SEARCH_TYPE_ALLOR' => 'All OR',
  'COMMENTS_SEARCH_TYPE_NAMEMAILWEB' => 'Name, email AND website',
  'COMMENTS_SEARCH_TYPE_NAMEMAILWEB_OR' => 'Name, email OR website',
  'COMMENTS_SEARCH_TYPE_TEXT' => 'Search text only',
  'COMMMENT_APPROVE' => 'Comment is approved',
  'COMMMENT_AUTHOR' => 'Name',
  'COMMMENT_CREATEDATE' => 'Written on',
  'COMMMENT_HEADLINE' => 'Comments',
  'COMMMENT_IMPORT_ARTICLEID' => 'Article ID',
  'COMMMENT_IPADDRESS' => 'Author IP address',
  'COMMMENT_LOCKIP' => 'Lock IP address',
  'COMMMENT_MOVE' => 'Move comment to article',
  'COMMMENT_PRIVATE' => 'Comment is private',
  'COMMMENT_SEARCH_ARTICLE' => 'Search in article with ID',
  'COMMMENT_SPAM' => 'Comment is spam',
  'COMMMENT_STATUS' => 'Status',
  'COMMMENT_TEXT' => 'Comment text',
  'COMMMENT_WEBSITE' => 'Website',
  'CONFIRM_MESSAGE' => 'Do you really want to do this action?',
  'CRONJOB_ANONYMIZEIPS' => 'Anonymize IP addresses from comments',
  'CRONJOB_BTN_CANCEL' => 'Cancel and release cronjob',
  'CRONJOB_CLEANUPTRASH' => 'Clean trash',
  'CRONJOB_CLEARLOGS' => 'Empty system logs',
  'CRONJOB_CLEARTEMP' => 'Clean up temporary files',
  'CRONJOB_DBBACKUP' => 'Back up system database',
  'CRONJOB_DBBACKUPS_SUBJECT' => 'Database backup was created',
  'CRONJOB_DBBACKUPS_TEXT' => 'At {{filetime}} the cronjob created a backup of the FanPress CM database tables. You can find the file at {{dumpfile}} and as an attachment to this email.',
  'CRONJOB_ECEDUTING' => 'Cronjob <em>{{cjname}}</em> is executed, please wait...',
  'CRONJOB_FILEINDEX' => 'Rebuild file index',
  'CRONJOB_FMTHUMBS' => 'Create file manager thumbnails',
  'CRONJOB_LIST_EXECDEMAND' => 'Run cronjob now',
  'CRONJOB_LIST_INTERVAL' => 'Interval',
  'CRONJOB_LIST_LASTEXEC' => 'Last executed',
  'CRONJOB_LIST_NAME' => 'Description',
  'CRONJOB_LIST_NEXTEXEC' => 'Next execution',
  'CRONJOB_MAIL_SUBJECT_POSTPONEDARTICLES' => 'Postponed articles were just published',
  'CRONJOB_POSTPONEDARTICLES' => 'Publish postponed articles',
  'CRONJOB_REMOVEREVISIONS' => 'Clean up article revisions',
  'CRONJOB_UNPINARTICLES' => 'Unpic articles by date',
  'CRONJOB_UPDATECHECK' => 'Check for updates',
  'CRONJOB_UPDATES_NEWVERSION' => 'New FanPress CM version available',
  'CRONJOB_UPDATES_NEWVERSION_TEXT' => 'There is a new version {{version}} of FanPress CM available. Please log in to the ACP to update.

{{acplink}}.',
  'CSRF_INVALID' => 'The CSRF token is invalid. The action was not performed!',
  'DASHBOARD_LOADING' => 'Dashboard containers are loaded',
  'DASHBOARD_MANAGE_CONTAINER' => 'Manage containers',
  'DASHBOARD_MANAGE_CONTAINER_ENABLE' => '{{icon="box"}} Re-enable container',
  'DASHBOARD_USERLIST' => '{{icon="users"}} Team contacts',
  'DEBUG_MODE' => 'Debug mode active',
  'DELETE_FAILED_ARTICLE' => 'The articles could not be deleted!',
  'DELETE_FAILED_CATEGORIES' => 'The categories could not be deleted!',
  'DELETE_FAILED_COMMENTS' => 'The comments could not be deleted!',
  'DELETE_FAILED_FILEAUTHORIMG' => 'The avatar could not be deleted!',
  'DELETE_FAILED_FILES' => 'The files could not be deleted!<br>{{filenames}}',
  'DELETE_FAILED_IPADDRESS' => 'The IP address could not be deleted!',
  'DELETE_FAILED_REVISIONS' => 'The revisions could not be deleted!',
  'DELETE_FAILED_ROLL' => 'The user role could not be deleted!',
  'DELETE_FAILED_ROLL_LAST' => 'The last roll cannot be deleted!',
  'DELETE_FAILED_ROLL_OWN' => 'You can\'t delete your own role!',
  'DELETE_FAILED_SMILEYS' => 'The smileys could not be deleted!',
  'DELETE_FAILED_TRASH' => 'The trash could not be emptied!',
  'DELETE_FAILED_USERS' => 'The user could not be deleted!',
  'DELETE_FAILED_USERSARTICLES' => 'Items cannot be moved to the user to be deleted!',
  'DELETE_FAILED_USERS_LAST' => 'The last user cannot be deleted!',
  'DELETE_FAILED_USERS_OWN' => 'You cannot delete your own account!',
  'DELETE_FAILED_WORDBAN' => 'The terms could not be deleted!',
  'DELETE_SUCCESS_CATEGORIES' => 'The categories have been deleted!',
  'DELETE_SUCCESS_COMMENTS' => 'The comments have been deleted!',
  'DELETE_SUCCESS_FILEAUTHORIMG' => 'The avatar was deleted!',
  'DELETE_SUCCESS_FILES' => 'The files have been deleted!<br>{{filenames}}',
  'DELETE_SUCCESS_IPADDRESS' => 'The IP addresses have been deleted!',
  'DELETE_SUCCESS_RENAME' => 'The file was renamed {{filename1}} to {{filename2}}!',
  'DELETE_SUCCESS_REVISIONS' => 'The revisions have been deleted!',
  'DELETE_SUCCESS_ROLL' => 'The user role has been deleted!',
  'DELETE_SUCCESS_SMILEYS' => 'The smileys have been deleted!',
  'DELETE_SUCCESS_TRASH' => 'The trash has been emptied!',
  'DELETE_SUCCESS_USERS' => 'The user has been deleted!',
  'DELETE_SUCCESS_WORDBAN' => 'The terms have been deleted!',
  'DEPRECATED_TWITTER_BUILDIN' => 'Out integrated Twitter connection will be removed in an upcoming release. More details will be give in the release notes!',
  'EDITOR_ARCHIVE' => 'Archive article',
  'EDITOR_ARTICLEIMAGE' => 'Set article image',
  'EDITOR_ARTICLEIMAGE_SHOW' => 'Show article image',
  'EDITOR_ARTICLE_ARTICLELINK' => 'Text for article links ("{{articleId}}-" +)',
  'EDITOR_ARTICLE_SHORTLINK' => 'Short link',
  'EDITOR_ARTICLE_SHORTLINK_COPY' => 'Copy link',
  'EDITOR_AUTOSAVE_RESTORE' => 'Restore last draft',
  'EDITOR_BACKTOCURRENT' => 'Return to the current version',
  'EDITOR_CATEGORIES_SEARCH' => 'Search and select categories...',
  'EDITOR_CHANGEAUTHOR' => 'Change author',
  'EDITOR_CODEX' => 'The codex for your role',
  'EDITOR_COMMENTS' => 'Comments are active',
  'EDITOR_COMMENTS_DELETE' => 'Delete comments',
  'EDITOR_CSS_CLASS' => 'CSS class',
  'EDITOR_DRAFT' => 'Article is draft',
  'EDITOR_HTML_BUTTONS_ACENTER' => 'Center',
  'EDITOR_HTML_BUTTONS_AJUSTIFY' => 'Justified',
  'EDITOR_HTML_BUTTONS_ALEFT' => 'Left aligned',
  'EDITOR_HTML_BUTTONS_ARIGHT' => 'Right aligned',
  'EDITOR_HTML_BUTTONS_ARTICLETPL' => 'Insert template',
  'EDITOR_HTML_BUTTONS_BOLD' => 'Bold',
  'EDITOR_HTML_BUTTONS_IFRAME' => 'Insert iFrame',
  'EDITOR_HTML_BUTTONS_ITALIC' => 'Italic',
  'EDITOR_HTML_BUTTONS_LISTOL' => 'Numbered list',
  'EDITOR_HTML_BUTTONS_LISTUL' => 'Enumeration list',
  'EDITOR_HTML_BUTTONS_PAGEBREAK' => 'Insert page break',
  'EDITOR_HTML_BUTTONS_QUOTE' => 'Insert quotation',
  'EDITOR_HTML_BUTTONS_QUOTE_BLOCK' => 'as paragraph',
  'EDITOR_HTML_BUTTONS_QUOTE_INLINE' => 'in line',
  'EDITOR_HTML_BUTTONS_QUOTE_TEXT' => 'Quote text',
  'EDITOR_HTML_BUTTONS_REMOVESTYLE' => 'Remove HTML tags',
  'EDITOR_HTML_BUTTONS_STRIKE' => 'Strikeout',
  'EDITOR_HTML_BUTTONS_SUB' => 'Subscript',
  'EDITOR_HTML_BUTTONS_SUP' => 'Superscript',
  'EDITOR_HTML_BUTTONS_SYMBOL' => 'Insert symbol',
  'EDITOR_HTML_BUTTONS_UNDERLINE' => 'Underline',
  'EDITOR_IMGALIGN' => 'Alignment',
  'EDITOR_IMGALTTXT' => 'Alternate text',
  'EDITOR_IMGPATH' => 'Source',
  'EDITOR_IMGPATH_ALT' => 'Alternate source',
  'EDITOR_INSERTCOLOR' => 'Insert color',
  'EDITOR_INSERTCOLOR_BACKGROUND' => 'as background color',
  'EDITOR_INSERTCOLOR_HEXCODE' => 'HTML color code',
  'EDITOR_INSERTCOLOR_TEXT' => 'as font color',
  'EDITOR_INSERTLINK' => 'Insert link',
  'EDITOR_INSERTLIST_TYPESIGN' => 'CSS list-style-type',
  'EDITOR_INSERTMEDIA' => 'Insert audio/video player',
  'EDITOR_INSERTMEDIA_AUDIO' => 'as audio player',
  'EDITOR_INSERTMEDIA_AUTOPLAY' => 'Autoplay',
  'EDITOR_INSERTMEDIA_CONTROLS' => 'Control elements',
  'EDITOR_INSERTMEDIA_FORMAT_SELECT' => 'Select media format',
  'EDITOR_INSERTMEDIA_POSTER' => 'Preview image',
  'EDITOR_INSERTMEDIA_VIDEO' => 'as video player',
  'EDITOR_INSERTPIC' => 'Insert image',
  'EDITOR_INSERTPIC_ASLINK' => 'Paste image as link',
  'EDITOR_INSERTSMILEY' => 'Insert smiley',
  'EDITOR_INSERTSYMBOL' => 'Insert symbol',
  'EDITOR_INSERTSYMBOL_ARROWS' => 'Arrows',
  'EDITOR_INSERTSYMBOL_CHARS' => 'Characters',
  'EDITOR_INSERTSYMBOL_MATH' => 'Mathematical characters',
  'EDITOR_INSERTSYMBOL_MISC' => 'Others',
  'EDITOR_INSERTTABLE' => 'Insert table',
  'EDITOR_INSERTTABLE_COLS' => 'Number of columns',
  'EDITOR_INSERTTABLE_ROWS' => 'Number of rows',
  'EDITOR_LINKREL' => 'Relation',
  'EDITOR_LINKTARGET' => 'Target',
  'EDITOR_LINKTXT' => 'Text',
  'EDITOR_LINKURL' => 'URL',
  'EDITOR_PARAGRAPH' => 'Paragraph',
  'EDITOR_PARAGRAPH_HEADLINE' => 'Headline {{num}}',
  'EDITOR_PINNED' => 'Pin article',
  'EDITOR_PINNED_DATE' => 'Pin article until',
  'EDITOR_POSTPONED_DATE' => 'Due date',
  'EDITOR_POSTPONED_DATETIME' => 'Due time',
  'EDITOR_POSTPONETO' => 'Postpone article',
  'EDITOR_PRE' => 'Preformatted text',
  'EDITOR_REVISION_DATE' => 'Revision date',
  'EDITOR_REVISION_DELETE' => 'Delete revisions',
  'EDITOR_REVISION_RESTORE' => 'Restore revision',
  'EDITOR_SELECTFS' => 'Font size',
  'EDITOR_SELECTSTYLES' => 'Styles',
  'EDITOR_SHARE' => 'Share this article by',
  'EDITOR_SHARES' => 'Shared content and likes',
  'EDITOR_SHARES_EMAIL' => 'Shared via email',
  'EDITOR_SHARES_FACEBOOK' => 'Shared via Facebook',
  'EDITOR_SHARES_LAST' => 'Last shared',
  'EDITOR_SHARES_LIKEBUTTON' => 'Like',
  'EDITOR_SHARES_PINTEREST' => 'Shared via Pinterest',
  'EDITOR_SHARES_REDDIT' => 'Shared via Reddit',
  'EDITOR_SHARES_TUMBLR' => 'Shared via Tumblr',
  'EDITOR_SHARES_TWITTER' => 'Shared via Twitter',
  'EDITOR_SHARES_WHATSAPP' => 'Shared via WhatsApp',
  'EDITOR_STATUS_APPROVAL' => 'Article must be appproved',
  'EDITOR_STATUS_ARCHIVE' => 'Article is archived',
  'EDITOR_STATUS_COMMENTS' => 'Comments are active',
  'EDITOR_STATUS_DRAFT' => 'Article saved as draft',
  'EDITOR_STATUS_INEDIT' => 'This article is currently being edited by {{username}}.',
  'EDITOR_STATUS_NOTINEDIT' => 'This article is no longer in being edited.',
  'EDITOR_STATUS_PINNED' => 'Article is pinned',
  'EDITOR_STATUS_POSTPONETO' => 'Article will be unlocked',
  'EDITOR_STATUS_REVISION' => 'Show revision (Revision = left, Current = right)',
  'EDITOR_STATUS_REVISION_SHOW' => 'Open revision',
  'EDITOR_TINYMCE_PLUGIN_OVERRIDE' => 'FPCM_TINYMCE_PLUGINS is defined, changes to plugins may not be applied.',
  'EDITOR_TWEET_ENABLED' => 'Create tweet',
  'EDITOR_TWEET_TEXT' => 'Twitter post text',
  'EDITOR_TWEET_TEXT_REPLACER' => 'Placeholder from tweet template usable!',
  'ERROR_IP_LOCKED' => 'Your IP address has been blocked for this action! To find out the reason, contact the operators of the site.',
  'FAILED_FILES_NEWTHUMBS' => 'Thumbnails could not be created!<br>{{filenames}}',
  'FILE_FORM_FILEADD' => 'Select file(s)',
  'FILE_FORM_UPLOADCANCEL' => 'Cancel upload',
  'FILE_FORM_UPLOADSTART' => 'Start upload',
  'FILE_LIST_ADDTOINDEX' => 'Indexing files...',
  'FILE_LIST_ALTTEXT' => 'Enter alternative text',
  'FILE_LIST_EDIT' => 'Edit image',
  'FILE_LIST_EDIT_CROP' => 'Crop',
  'FILE_LIST_EDIT_MOVE' => 'Move',
  'FILE_LIST_EDIT_RESIZE' => 'Resize',
  'FILE_LIST_EDIT_RESIZE_NOTICE' => 'The width/height is subsequently adjusted to the changed value when saving based on the aspect ratio.',
  'FILE_LIST_EDIT_ROTATE_ANTICLOCKWISE' => 'Rotate counterclockwise',
  'FILE_LIST_EDIT_ROTATE_CLOCKWISE' => 'Rotate clockwise',
  'FILE_LIST_EDIT_ZOOMIN' => 'Zoom in',
  'FILE_LIST_EDIT_ZOOMOUT' => 'Zoom out',
  'FILE_LIST_FILECREDITS' => 'Credits',
  'FILE_LIST_FILEHASH' => 'File hash',
  'FILE_LIST_FILENAME' => 'File name',
  'FILE_LIST_FILESIZE' => 'File size',
  'FILE_LIST_FILETYPE' => 'MIME type',
  'FILE_LIST_INSERTGALLERY' => 'Insert gallery',
  'FILE_LIST_INSERT_FULL' => 'Insert image URL',
  'FILE_LIST_INSERT_THUMB' => 'Insert thumbnail URL',
  'FILE_LIST_NEWTHUMBS' => 'Generate thumbnails',
  'FILE_LIST_OPEN_FULL' => 'Open image',
  'FILE_LIST_OPEN_THUMB' => 'Open thumbnail',
  'FILE_LIST_PHPMAXINFO' => 'Maximum {{filecount}} files with {{filesize}}.',
  'FILE_LIST_RENAME' => 'Rename',
  'FILE_LIST_RENAME_NEWNAME' => 'Please enter a new filename:',
  'FILE_LIST_RESOLUTION' => 'Resolution',
  'FILE_LIST_RESOLUTION_PIXEL' => 'Pixel',
  'FILE_LIST_SEARCHTEXT' => 'Filename or alternate text',
  'FILE_LIST_SMILEYADD' => 'Add smiley',
  'FILE_LIST_SMILEYCODE' => 'Smiley code',
  'FILE_LIST_SMILEYEDIT' => 'Edit smiley',
  'FILE_LIST_THUMB_SIZE' => 'Thumbnail size',
  'FILE_LIST_UPLOADDROP' => 'Drop files to upload here',
  'FILE_LIST_UPLOADFORM' => 'Upload files',
  'FILE_LIST_UPLOADSELECTED' => 'Files selected for uploading',
  'FILE_LIST_UPLOAD_BY' => 'Uploaded by',
  'FILE_LIST_UPLOAD_NOTFOUND' => 'The associated file was not found in the upload folder!',
  'FILE_NOT_WRITABLE' => 'The selected file is not writable, please check the permissions on the server.',
  'GLOBAL_ACTIONS' => 'Actions',
  'GLOBAL_ACTION_PERFORM' => 'Action to perform',
  'GLOBAL_ADMINISTRATOR' => 'Administrator',
  'GLOBAL_AUTHOR' => 'Author',
  'GLOBAL_AUTHOR_EDITOR' => 'Written by',
  'GLOBAL_BACK' => 'Back',
  'GLOBAL_CACHE_CLEAR' => 'Clear cache',
  'GLOBAL_CLOSE' => 'Close',
  'GLOBAL_CONFIRM' => 'Please confirm',
  'GLOBAL_COPY' => 'Copy',
  'GLOBAL_COPY_OF' => 'Copy of "%s"',
  'GLOBAL_COPY_OF_FILE' => 'Copy_of_%s',
  'GLOBAL_DELETE' => 'Delete',
  'GLOBAL_DEPRECATED' => 'Deprecated, will be removed shortly',
  'GLOBAL_DISABLE' => 'Disable',
  'GLOBAL_DOWNLOAD' => 'Download',
  'GLOBAL_EDIT' => 'Edit',
  'GLOBAL_EDITOR' => 'Editor',
  'GLOBAL_EDIT_SELECTED' => 'Edit selected',
  'GLOBAL_EMAIL' => 'E-mail address',
  'GLOBAL_ENABLE' => 'Enable',
  'GLOBAL_EXTENDED' => 'Extended',
  'GLOBAL_EXTERNAL' => 'External',
  'GLOBAL_FRONTEND_OPEN' => 'View article on website',
  'GLOBAL_HIDE' => 'Hide',
  'GLOBAL_HTMLTAGS_ALLOWED' => 'Allowed HTML tags',
  'GLOBAL_INFO' => 'Information',
  'GLOBAL_INSERT' => 'Insert',
  'GLOBAL_LASTCHANGE' => 'Last modified',
  'GLOBAL_METADATA' => 'Meta information',
  'GLOBAL_NEW' => 'New',
  'GLOBAL_NEXT' => 'Next',
  'GLOBAL_NO' => 'No',
  'GLOBAL_NOCHANGE' => 'No changes made',
  'GLOBAL_NOCHANGE_APPLY' => 'No changes',
  'GLOBAL_NOTFOUND' => 'Not found',
  'GLOBAL_NOTFOUND2' => 'No items found...',
  'GLOBAL_NOTFOUND_FILE' => 'File not found!',
  'GLOBAL_NOT_WRITABLE' => 'not writable',
  'GLOBAL_OK' => 'OK',
  'GLOBAL_OPENNEWWIN' => 'Open in new window',
  'GLOBAL_OPTIONAL' => 'optional',
  'GLOBAL_PAGER' => 'Page {{current}} of {{total}}',
  'GLOBAL_PASSWORD' => 'Password',
  'GLOBAL_PASSWORD_CONFIRM' => 'Enter current password for confirmation',
  'GLOBAL_PLEASEWAIT' => 'One moment please ...',
  'GLOBAL_PREVIEW' => 'Show preview',
  'GLOBAL_PROPERTIES' => 'Properties',
  'GLOBAL_RELOAD' => 'Refresh',
  'GLOBAL_RESET' => 'Reset',
  'GLOBAL_SAVE' => 'Save',
  'GLOBAL_SCROLLTOP' => 'Scroll to top',
  'GLOBAL_SELECT' => 'Please select',
  'GLOBAL_SELECTALL' => 'Select all',
  'GLOBAL_SHOW' => 'Show',
  'GLOBAL_SUBMIT' => 'Submit',
  'GLOBAL_USERNAME' => 'Username',
  'GLOBAL_USER_ON_TIME' => '{{username}} on {{time}}',
  'GLOBAL_WRITABLE' => 'writable',
  'GLOBAL_WRITEMAIL' => 'Compose email',
  'GLOBAL_YES' => 'Yes',
  'HEADLINE' => 'FanPress CM News System',
  'HELP_BTN_OPEN' => 'Open help entry',
  'HL_ARCHIVE' => 'Archive',
  'HL_ARTICLES' => 'Manage article',
  'HL_ARTICLE_ADD' => 'Write article',
  'HL_ARTICLE_EDIT' => 'Articles',
  'HL_ARTICLE_EDIT_ACTIVE' => 'Active articles',
  'HL_ARTICLE_EDIT_ALL' => 'Show all',
  'HL_ARTICLE_EDIT_ARCHIVE' => 'Archived articles',
  'HL_ARTICLE_EDIT_COMMENTS' => '{{count}} Comment(s)',
  'HL_ARTICLE_EDIT_REVISIONS' => '{{count}} Revision(s)',
  'HL_BACKUPS' => 'Backup manager',
  'HL_CATEGORIES_MNG' => 'Categories',
  'HL_COMMENTS_MNG' => 'Manager comments',
  'HL_CRONJOBS' => 'Cronjobs',
  'HL_DASHBOARD' => 'Dashboard',
  'HL_FILES_MNG' => 'File manager',
  'HL_FRONTEND' => 'Front end',
  'HL_HELP' => 'Help',
  'HL_HELP_BACKDROP' => 'Backdrop image by',
  'HL_HELP_CACHE' => 'Cache',
  'HL_HELP_LICENCE' => 'License information',
  'HL_HELP_SUPPORT' => 'Contact & Support',
  'HL_LOGS' => 'Logs',
  'HL_LOGS_CRONJOBS' => 'Cron jobs',
  'HL_LOGS_DATABASE' => 'Database',
  'HL_LOGS_ERROR' => 'Errors',
  'HL_LOGS_EVENTS' => 'Events',
  'HL_LOGS_PACKAGES' => 'Package manager',
  'HL_LOGS_SESSIONS' => 'Sessions',
  'HL_LOGS_SYSTEM' => 'Others',
  'HL_MODULES' => 'Modules',
  'HL_OPTIONS' => 'Options',
  'HL_OPTIONS_IPBLOCKING' => 'IP addresses',
  'HL_OPTIONS_PERMISSIONS' => 'Permissions',
  'HL_OPTIONS_SMILEYS' => 'Smileys',
  'HL_OPTIONS_SYSTEM' => 'System settings',
  'HL_OPTIONS_TEMPLATES' => 'Templates',
  'HL_OPTIONS_USERS' => 'Users and roles',
  'HL_OPTIONS_WORDBAN' => 'Text censorship/autocorrection',
  'HL_PACKAGEMGR_SYSUPDATES' => 'Update FanPress CM',
  'HL_PROFILE' => 'Profile',
  'HL_TEMPLATE_PREVIEW' => 'Template preview',
  'HL_UTILITIES' => 'Tools',
  'IMPORT_DELIMITER' => 'Delimiter',
  'IMPORT_ENCLOSURE' => 'Boundary mark',
  'IMPORT_EXCLUDE_FIRST' => 'Skip first row',
  'IMPORT_FIELDS' => 'Field assignment',
  'IMPORT_FIELDS_CSV' => 'Order in CSV file',
  'IMPORT_FIELDS_OBJECT' => 'Available fields',
  'IMPORT_FILE' => 'CSV file',
  'IMPORT_ITEM' => 'Import to',
  'IMPORT_MAIN' => 'CSV import',
  'IMPORT_MSG_CSVINVALID' => 'The submitted file is not a valid CSV file!',
  'IMPORT_MSG_CSVNOTFOUND' => 'The uploaded CSV file was not found. Perform an upload, reset the import before if necessary.',
  'IMPORT_MSG_EMPTYFIELD' => 'The selected fields must not be empty.',
  'IMPORT_MSG_FAILEDSAVE' => 'An error occurred while saving the files to be imported. For details check the system logs.',
  'IMPORT_MSG_FINISHED' => 'The CSV import has been completed.',
  'IMPORT_MSG_INITFAILED' => 'Error while initializing the import, no import identifier available!',
  'IMPORT_MSG_INVALIDIMPORTTYPE' => 'The selected import destination is invalid: {{importtype}}',
  'IMPORT_MSG_INVALIDIMPORTTYPE_NONE' => 'Please select an import destination and the fields to import.',
  'IMPORT_MSG_NOFIELDS' => 'No field assignment made. Select the fields to be filled and sort them according to the order in the CSV file.',
  'IMPORT_MSG_NOFILE' => 'No file has been uploaded for import.',
  'IMPORT_MSG_NOHANDLE' => 'The CSV file to be imported could not be opened.',
  'IMPORT_NOTICE_UTF8' => 'The data to be imported must be in the UTF-8 character set, otherwise there may be defective special characters!',
  'IMPORT_OPTIONS' => 'Import settings',
  'IMPORT_PROGRESS' => 'Import {{filename}}...',
  'IMPORT_START' => 'Start import',
  'INSTALLER' => 'Installation Wizard',
  'INSTALLER_ADMINUSER' => 'Administrator account',
  'INSTALLER_CREATETABLES' => 'Database tables',
  'INSTALLER_CREATETABLES_ERROR' => 'Error processing the database structure',
  'INSTALLER_CREATETABLES_HEAD' => 'create database tables, please wait...',
  'INSTALLER_CREATETABLES_STEP' => 'create table <em>{{tablename}}</em>...',
  'INSTALLER_DBCONNECTION' => 'Database connection',
  'INSTALLER_DBCONNECTION_FAILEDMSG' => 'No connection to the database could be established with the entered data!',
  'INSTALLER_DBCONNECTION_HOST' => 'Host (mostly localhost)',
  'INSTALLER_DBCONNECTION_NAME' => 'Database name',
  'INSTALLER_DBCONNECTION_PASS' => 'Password',
  'INSTALLER_DBCONNECTION_PREF' => 'Table prefix',
  'INSTALLER_DBCONNECTION_TYPE' => 'Type',
  'INSTALLER_DBCONNECTION_USER' => 'User',
  'INSTALLER_FINALIZE' => 'Finish installation',
  'INSTALLER_FINALIZE_DIABLED' => '<strong>Important:</strong> Delete via FTP the file <strong>/data/config/installer.enabled</strong> to disable the installation wizard, if the file still exists!!!!',
  'INSTALLER_FINALIZE_TEXT' => '<strong>Congratulations!</strong> The installation of FanPress CM has been completed successfully! You can now log in to your system! {{icon="smile-o"}}',
  'INSTALLER_LANGUAGE_SELECT' => 'Choose language',
  'INSTALLER_SYSCHECK' => 'System requirements',
  'INSTALLER_SYSCHECK_FAILEDMSG' => 'FanPress CM cannot be installed because the system requirements are not met!',
  'INSTALLER_SYSTEMCONFIG' => 'System settings',
  'IPLIST_ADDIP' => 'Block IP address',
  'IPLIST_BLOCKTYPE' => 'Lock type',
  'IPLIST_IPADDRESS' => 'IP address',
  'IPLIST_IPTIME' => 'Locked on',
  'IPLIST_NOACCESS' => 'No front end access',
  'IPLIST_NOCOMMENTS' => 'Do not post comments',
  'IPLIST_NOLOGIN' => 'No ACP login',
  'LABEL_FIELD_ARTICLE_RELATESTO' => 'Artikel relates to',
  'LABEL_FIELD_FILE_CROPPER_NAME' => 'Filename pattern for edited images',
  'LABEL_FIELD_FILE_CROPPER_NAME_HELP' => '{{filename}}: filename, {{date}}: current date, {{datelong}}: current date with time, {{hash}}: fiel hash, {{userid}}:  user id, {{random}}: random number',
  'LABEL_FIELD_OPENQR' => 'Display QR code',
  'LABEL_SEARCH_GLOBAL' => 'Enter at least three characters...',
  'LABEL_SEARCH_GLOBAL_RESULTSIZE' => 'Not all {{result_count}} search resulsts are displayed.',
  'LOAD_FAILED_ARTICLE' => 'The article you are looking for was not found.',
  'LOAD_FAILED_ARTICLE_LIST' => 'The page you are looking for was not found.',
  'LOAD_FAILED_CATEGORY' => 'The category you are looking for was not found.',
  'LOAD_FAILED_COMMENT' => 'The comment you were looking for was not found.',
  'LOAD_FAILED_COMMENT_ARTICLE' => 'The article associated with this comment was not found. The comment must be moved to another article to be visible in the front end.',
  'LOAD_FAILED_ROLL' => 'The searched user role was not found.',
  'LOAD_FAILED_USER' => 'The user you are looking for was not found.',
  'LOAD_FAILED_WORDBAN' => 'The term was not found.',
  'LOGIN_ATTEMPTS_MAX' => 'You entered your username or password incorrectly for {{logincount}} times in a row. Access was locked at {{lockeddate}} for {{lockedtime}} minutes.',
  'LOGIN_AUTHCODE' => 'Enter six-digit Authenticator code',
  'LOGIN_BTN' => 'Log in',
  'LOGIN_FAILED' => 'The username or password is incorrect. Please try again.',
  'LOGIN_FAILED_CODE' => 'The inserted Authenticator code was invalid. Please try again.',
  'LOGIN_FAILED_DISABLED' => 'The specified username has been deactivated.',
  'LOGIN_NEWPASSWORD' => 'Request new password',
  'LOGIN_PASSWORD_RESET' => 'Your password has been successfully reset! Check your inbox for the email with the new password.',
  'LOGIN_PASSWORD_RESET_FAILED' => 'An error occurred while requesting the new password!',
  'LOGIN_REQUIRED' => 'Please log in to access the requested page!',
  'LOGOUT_BTN' => 'Logout',
  'LOGS_CLEARED_LOG_FAILED' => 'The selected log could not be cleared!',
  'LOGS_CLEARED_LOG_OK' => 'The selected log was cleared.',
  'LOGS_CLEARLOG' => 'Clear',
  'LOGS_LIST_IPADDRESS' => 'IP address',
  'LOGS_LIST_PERIOD' => 'Login period',
  'LOGS_LIST_LOGIN' => 'Login on',
  'LOGS_LIST_LOGOUT' => 'Logout at',
  'LOGS_LIST_SESSIONID' => 'Identifier',
  'LOGS_LIST_TEXT' => 'Log data',
  'LOGS_LIST_TIME' => 'Time',
  'LOGS_LIST_USER' => 'User',
  'LOGS_LIST_USERAGENT' => 'User agent',
  'MAINTENANCE_MODE_ENABLED' => 'The maintenance mode of FanPress CM is currently active, therefore this function is not available at the moment.',
  'MODULES_FAILED_DEPENCIES' => 'Unfulfilled dependencies were detected, therefore the module cannot be installed!',
  'MODULES_FAILED_DISABLE' => 'The selected module could not be disabled.',
  'MODULES_FAILED_ENABLE' => 'The selected module could not be activated.',
  'MODULES_FAILED_FSWRITE' => 'The file system is not writable for the module or its files!',
  'MODULES_FAILED_INSTALL' => 'The selected module could not be installed.',
  'MODULES_FAILED_UNINSTALL' => 'The selected module could not be uninstalled.',
  'MODULES_KEY_INVALID' => 'The module key is invalid, see the event log for details.',
  'MODULES_LIST_AUTHOR' => 'Author',
  'MODULES_LIST_AVAILABLE' => 'Available modules',
  'MODULES_LIST_BACKTOLIST' => 'back to module list',
  'MODULES_LIST_CONFIGURE' => 'Configure module',
  'MODULES_LIST_DATAPATH' => 'Path in /data folder',
  'MODULES_LIST_DELETE' => 'Delete module',
  'MODULES_LIST_DESCRIPTION' => 'Description',
  'MODULES_LIST_DISABLE' => 'Deactivate module',
  'MODULES_LIST_DOWNLOAD' => 'Download module package file',
  'MODULES_LIST_ENABLE' => 'Activate module',
  'MODULES_LIST_HEADLINE' => 'Installed modules',
  'MODULES_LIST_INFORMATIONS' => 'Module detail information',
  'MODULES_LIST_INSTALL' => 'Install module',
  'MODULES_LIST_INSTALLING' => 'Install module {{modulekey}}',
  'MODULES_LIST_KEY' => 'Key',
  'MODULES_LIST_LICENCE' => 'Licence',
  'MODULES_LIST_LINK' => 'Info link',
  'MODULES_LIST_NAME' => 'Name',
  'MODULES_LIST_REQUIRE_FPCM' => 'Requires FanPress CM',
  'MODULES_LIST_REQUIRE_PHP' => 'Requires PHP',
  'MODULES_LIST_SUPPORT' => 'Support and contact',
  'MODULES_LIST_UNINSTALL' => 'Uninstall module',
  'MODULES_LIST_UPDATE' => 'Update module',
  'MODULES_LIST_UPDATE_ALL' => 'Apply updates for all modules',
  'MODULES_LIST_UPDATE_NEXT' => 'To next module update...',
  'MODULES_LIST_UPDATING' => 'Update module {{modulekey}}',
  'MODULES_LIST_UPLOAD' => 'Upload module package file',
  'MODULES_LIST_VERSION_LOCAL' => 'Version (local)',
  'MODULES_LIST_VERSION_REMOTE' => 'Version (Server)',
  'MSG_FILES_CREATETHUMBS' => 'Regenerating thumbnails...',
  'NAVIGATION_SHOW' => 'Menu',
  'NOTIFICATION_ERROR_EVENTS' => 'An error occurred during the event "{{eventName}}". Check the system logs and update your installed modules.',
  'NOTIFICATION_EXPERIMENTAL_MINJS' => 'Minimized JavaScript files are used. Changes may not be applied immediately.',
  'PACKAGEMANAGER_BACKUPFS' => 'Create filesystem backup...',
  'PACKAGEMANAGER_CHECKLOCAL' => 'Checking file system...',
  'PACKAGEMANAGER_CHECKPKG' => 'Check package information <em>{{var}}</em>',
  'PACKAGEMANAGER_CLEANUP' => 'Clean up the system...',
  'PACKAGEMANAGER_CURRENTLANGUAGE' => 'Current language',
  'PACKAGEMANAGER_CURRENTVERSION' => 'Current version',
  'PACKAGEMANAGER_DOWNLOAD' => 'Downloading package <em>{{var}} {{var2}}</em> .',
  'PACKAGEMANAGER_EXTRACT' => 'Unpack package <em>{{var}}</em>',
  'PACKAGEMANAGER_FAILED' => 'An error occurred while installing the package. Detailed information is included in the error log.',
  'PACKAGEMANAGER_FAILED_UPDATE' => 'An error occurred while updating the package. Detailed information is included in the error log.',
  'PACKAGEMANAGER_MAINTENANCE_DIS' => 'Disable maintenance mode...',
  'PACKAGEMANAGER_MAINTENANCE_EN' => 'Enable maintenance mode...',
  'PACKAGEMANAGER_NEWVERSION' => 'New version:',
  'PACKAGEMANAGER_SUCCESS' => 'The installation of the package was successfully completed.',
  'PACKAGEMANAGER_SUCCESS_UPDATE' => 'The package update was performed successfully.',
  'PACKAGEMANAGER_TIMER' => 'Time required:',
  'PACKAGEMANAGER_UPDATEDB' => 'Update is being completed...',
  'PACKAGEMANAGER_UPDATEFS' => 'Update file system...',
  'PACKAGEMANAGER_UPDATELOG' => 'Update package manager log...',
  'PACKAGES_BACKTODASHBOARD' => 'Back to dashboard',
  'PACKAGES_FAILED_DOWNLOAD_UNTRUSTED' => 'The available package file is not downloaded because the package server <em>{{var}}</em> is not trusted.',
  'PACKAGES_FAILED_ERROR901' => 'No connection to the packet server could be established!',
  'PACKAGES_FAILED_ERROR902' => 'No local package file could be created!',
  'PACKAGES_FAILED_ERROR903' => 'An error occurred while writing the local package file!',
  'PACKAGES_FAILED_ERROR904' => 'The local package file was not found!',
  'PACKAGES_FAILED_ERROR906' => 'The archive file could not be opened!',
  'PACKAGES_FAILED_ERROR907' => 'An error occurred while unpacking the archive file!',
  'PACKAGES_FAILED_ERROR908' => 'An error occurred while updating the local files! For more information, see the package manager log.',
  'PACKAGES_FAILED_ERROR_BACKUPS' => 'An error occurred while creating the file system backup! Please check the event log for detailed information.',
  'PACKAGES_MANUALCHECK' => 'Check for updates',
  'PACKAGES_UPDATE' => 'Start update',
  'PACKAGES_UPDATES_LIST' => 'Display updates',
  'PASSWORD_NEWPASSWORDSET_SUBJECT' => 'Set new password',
  'PASSWORD_NEWPASSWORDSET_TEXT' => 'For your FanPress CM account <b>{{username}}</b> the password <b>{{newpass}}</b> has been set. With this data you can log in and also set your own password.',
  'PASSWORD_RESET_SUBJECT' => 'New password requested',
  'PASSWORD_RESET_TEXT' => 'A new password has been requested for you. This is <b>{{newpass}}</b>. If you have not done this yourself, please contact an administrator as soon as possible.',
  'PASSWORD_TOGGLE' => 'Show password',
  'PERMISSIONS_REQUIRED' => 'You do not have permissions to access this page!',
  'PERMISSION_ARTICLES' => 'Article',
  'PERMISSION_ARTICLE_ADD' => 'Write article',
  'PERMISSION_ARTICLE_APPROVE' => 'Articles need to be approved',
  'PERMISSION_ARTICLE_ARCHIVE' => 'Archive articles and edit them in the archive',
  'PERMISSION_ARTICLE_AUTHORS' => 'Change article author',
  'PERMISSION_ARTICLE_DELETE' => 'Delete article',
  'PERMISSION_ARTICLE_EDIT' => 'Edit own articles',
  'PERMISSION_ARTICLE_EDITALL' => 'Edit active articles',
  'PERMISSION_ARTICLE_MASSEDIT' => 'Bulk edit articles',
  'PERMISSION_ARTICLE_REVISIONS' => 'Manage revisions',
  'PERMISSION_COMMENTS' => 'Comments',
  'PERMISSION_COMMENT_APPROVE' => 'Approve comments',
  'PERMISSION_COMMENT_DELETE' => 'Delete comments',
  'PERMISSION_COMMENT_EDIT' => 'Edit comments on own articles',
  'PERMISSION_COMMENT_EDITALL' => 'Edit comments on all articles',
  'PERMISSION_COMMENT_LOCKIP' => 'Lock IP address of the comment',
  'PERMISSION_COMMENT_MASSEDIT' => 'Bulk edit comments',
  'PERMISSION_COMMENT_MOVE' => 'Move comments to other article',
  'PERMISSION_COMMENT_PRIVATE' => 'Set comments to "private"',
  'PERMISSION_MODULES' => 'Modules',
  'PERMISSION_MODULES_CONFIGURE' => 'Configure modules',
  'PERMISSION_MODULES_INSTALL' => 'Install modules',
  'PERMISSION_MODULES_UNINSTALL' => 'Uninstall modules',
  'PERMISSION_SYSTEM' => 'System',
  'PERMISSION_SYSTEM_BACKUPS' => 'Manage backups',
  'PERMISSION_SYSTEM_CATEGORIES' => 'Manage categories',
  'PERMISSION_SYSTEM_CRONS' => 'Manage cronjobs',
  'PERMISSION_SYSTEM_CSVIMPORT' => 'Use CSV import',
  'PERMISSION_SYSTEM_DRAFTS' => 'Manage article templates',
  'PERMISSION_SYSTEM_IPADDR' => 'Manage IP addresses',
  'PERMISSION_SYSTEM_LOGS' => 'Manage system logs',
  'PERMISSION_SYSTEM_OPTIONS' => 'Manage system settings',
  'PERMISSION_SYSTEM_PERMISSIONS' => 'Manage permissions',
  'PERMISSION_SYSTEM_PROFILE' => 'Modify profile',
  'PERMISSION_SYSTEM_ROLLS' => 'Manage roles',
  'PERMISSION_SYSTEM_SMILEYS' => 'Manage smileys',
  'PERMISSION_SYSTEM_TEMPLATES' => 'Manage templates',
  'PERMISSION_SYSTEM_UPDATE' => 'Perform updates',
  'PERMISSION_SYSTEM_USERS' => 'Manage users',
  'PERMISSION_SYSTEM_WORDBAN' => 'Manage text censorship/autocorrection',
  'PERMISSION_UPLOADS' => 'File manager',
  'PERMISSION_UPLOADS_ADD' => 'Upload files',
  'PERMISSION_UPLOADS_DELETE' => 'Delete files',
  'PERMISSION_UPLOADS_RENAME' => 'Rename files',
  'PERMISSION_UPLOADS_THUMBS' => 'Generate thumbnails',
  'PERMISSION_UPLOADS_VISIBLE' => 'File manager is visible',
  'PROFILE_MENU_LOGGEDINAS' => 'Hey {{username}}!',
  'PROFILE_MENU_LOGGEDINSINCE' => 'You logged in since',
  'PROFILE_MENU_NOTIFICATIONS' => 'Notifications',
  'PROFILE_MENU_OPENPROFILE' => 'User profile',
  'PROFILE_MENU_YOURIP' => 'Your IP address:',
  'PROFILE_OPEN' => 'Open my profile',
  'PUBLIC_ARCHIVE_LIMIT' => 'The archive only shows articles that were published after <strong>{{archievDate}}</strong>.',
  'PUBLIC_ARTICLE_OLD' => 'This article is very old yet. Its information can be wrong or outdated.',
  'PUBLIC_ARTICLE_PINNED' => 'This article is pinned and displayed above all others.',
  'PUBLIC_COMMENT_EMAIL_SUBJECT' => 'A new comment has been posted.',
  'PUBLIC_COMMENT_EMAIL_TEXT' => 'A comment was written by {{name}} (email address: {{email}}) on the article {{articleurl}}.

{{commenttext}}

Log in to moderate the comment. {{systemurl}}',
  'PUBLIC_FAILED_CAPTCHA' => 'You did not answer the captcha question correctly!',
  'PUBLIC_FAILED_EMAIL' => 'No valid e-mail address was entered!',
  'PUBLIC_FAILED_FLOOD' => 'Please wait at least {{seconds}} seconds before posting another comment!',
  'PUBLIC_FAILED_NAME' => 'Please enter your name!',
  'PUBLIC_PRIVACY' => 'You must agree to our privacy policy to post a comment.',
  'PUBLIC_SHARE_LIKE' => 'Thanks for the like. We are happy that you like the post!',
  'RECENT_ARTICLES' => '{{icon="book"}} Recent articles',
  'RECENT_COMMENTS' => '{{icon="comments"}} Recent comments',
  'RECENT_FPCMNEWS' => '{{icon="rss"}} Latest FanPress CM News',
  'RECENT_TWEETS' => '{{icon="twitter" prefix="fab"}} Recent Tweets',
  'RECENT_TWEETS_REWTEETS' => 'Retweets',
  'RECENT_TWEETS_LOAD_FAILURE' => 'The Twitter history could not be loaded due to API level restrictions.',
  'RENAME_FAILED_FILE' => 'The file {{filename1}} could not be renamed to {{filename2}}!',
  'RSSFEED_DISABLED' => 'The RSS feed is disabled. Contact the site owner for more information.',
  'SAVE_FAILED_ARTICLE' => 'The article could not be saved!',
  'SAVE_FAILED_ARTICLEAPPROVAL' => 'The article releases could not be changed!',
  'SAVE_FAILED_ARTICLEARCHIVE' => 'The articles could not be archived!',
  'SAVE_FAILED_ARTICLECOMMENTS' => 'The comments could not be (de)activated for the articles!',
  'SAVE_FAILED_ARTICLENEWTWEET' => 'No tweets could be generated for the articles!<br>{titles}}',
  'SAVE_FAILED_ARTICLEPINN' => 'The articles could not be (un)pinned!',
  'SAVE_FAILED_ARTICLERESTORE' => 'The elements could not be restored!',
  'SAVE_FAILED_ARTICLEREVRESTORE' => 'The revision could not be restored!',
  'SAVE_FAILED_ARTICLES' => 'The changes to the articles could not be saved!',
  'SAVE_FAILED_ARTICLETEMPLATE' => 'The article template could not be saved!',
  'SAVE_FAILED_ARTICLE_EMPTY' => 'You must enter a title and text before you can save the article!',
  'SAVE_FAILED_CATEGORY' => 'The category could not be saved!',
  'SAVE_FAILED_CATEGORY_EXISTS' => 'The category name already exists! Please choose another name.',
  'SAVE_FAILED_COMMENT' => 'The comment could not be saved!',
  'SAVE_FAILED_COMMENTS' => 'The changes to the comments could not be saved!',
  'SAVE_FAILED_FILE_ALTTEXT' => 'The alternative test could not be saved.',
  'SAVE_FAILED_IPADDRESS' => 'The IP address could not be blocked!',
  'SAVE_FAILED_IPADDRESS_SAME' => 'Your own IP address cannot be blocked!',
  'SAVE_FAILED_IPINVALID' => 'The entered IP address is invalid and therefore cannot be blocked!',
  'SAVE_FAILED_OPTIONS' => 'The changes to the configuration could not be saved!',
  'SAVE_FAILED_OPTIONS_MODULES' => 'The changes to the configuration could not be saved because no data was found in the "config" field!',
  'SAVE_FAILED_OPTIONS_SMTP_CONECT' => 'SMTP connection was not successful!',
  'SAVE_FAILED_OPTIONS_SMTP_HOST' => 'An incorrect value was detected for the SMTP server address!',
  'SAVE_FAILED_PASSWORD_MATCH' => 'The passwords entered do not match.',
  'SAVE_FAILED_PASSWORD_MATCH_CURRENT' => 'The current password is wrong.',
  'SAVE_FAILED_PASSWORD_SECURITY' => 'A password must contain upper and lower case letters, numbers and be at least 6 characters long.',
  'SAVE_FAILED_PASSWORD_SECURITY_PWNDPASS' => 'The password entered is used very frequently and is therefore potentially dangerous! It should not be used.',
  'SAVE_FAILED_PERMISSIONS' => 'The changes to the permissions for the selected role could not be saved!',
  'SAVE_FAILED_ROLL' => 'The user role could not be saved!',
  'SAVE_FAILED_ROLL_EXISTS' => 'A role with the entered name already exists.',
  'SAVE_FAILED_SMILEY' => 'The smiley could not be saved!',
  'SAVE_FAILED_TEMPLATE' => 'An error occurred while saving the template {{filename}}!',
  'SAVE_FAILED_TEMPLATE_CF_PRIVACYMISSING' => 'The comment form template could not be saved. The placeholder {{privacyComfirmation}} is missing!',
  'SAVE_FAILED_TEMPLATE_CF_URLMISSING' => 'The comment form template could not be saved. The placeholder {{submitUrl}} is missing!',
  'SAVE_FAILED_UPLOADAUTHORIMG' => 'An error occurred while uploading the avatar!',
  'SAVE_FAILED_UPLOADMODULE' => 'An error occurred while uploading the module package file!',
  'SAVE_FAILED_UPLOADPHP' => 'An error occurred while uploading the files!<br>{{filenames}}',
  'SAVE_FAILED_UPLOADTPLFILE' => 'An error occurred while uploading the template!',
  'SAVE_FAILED_UPLOAD_COPY' => 'An error occurred trying to copy the file!!',
  'SAVE_FAILED_UPLOAD_GEN' => 'The following error occurred while uploading the files: <em>{{uploadMsg}}</em>.',
  'SAVE_FAILED_USER' => 'The user could not be saved!',
  'SAVE_FAILED_USER_DISABLE' => 'The user could not be deactivated!',
  'SAVE_FAILED_USER_DISABLE_LAST' => 'The last user cannot be deactivated!',
  'SAVE_FAILED_USER_DISABLE_OWN' => 'You cannot deactivate your own account!',
  'SAVE_FAILED_USER_EMAIL' => 'No valid e-mail address was entered for the user!',
  'SAVE_FAILED_USER_ENABLE' => 'The user could not be activated!',
  'SAVE_FAILED_USER_EXISTS' => 'A user with the selected username already exists!',
  'SAVE_FAILED_USER_PROFILE' => 'The change to the profile could not be saved!',
  'SAVE_FAILED_USER_PROFILEEMAIL' => 'You must provide a valid email address!',
  'SAVE_FAILED_USER_SECURITY' => 'The entered username is potentially dangerous and therefore cannot be used!',
  'SAVE_FAILED_WORDBAN' => 'The term could not be saved!',
  'SAVE_SUCCESS_ADDCATEGORY' => 'The category has been saved!',
  'SAVE_SUCCESS_ADDROLL' => 'The user role has been saved!',
  'SAVE_SUCCESS_ADDUSER' => 'The user has been saved!',
  'SAVE_SUCCESS_ARTICLE' => 'The article has been saved!',
  'SAVE_SUCCESS_ARTICLENEWTWEET' => 'New tweets were created for the articles!<br>{{titles}}',
  'SAVE_SUCCESS_ARTICLERESTORE' => 'The elements have been restored!',
  'SAVE_SUCCESS_ARTICLEREVRESTORE' => 'The revision has been restored!',
  'SAVE_SUCCESS_ARTICLETEMPLATE' => 'The article template has been saved!',
  'SAVE_SUCCESS_ARTICLE_APPROVAL' => 'The article was saved, but must be approved!',
  'SAVE_SUCCESS_COMMENT' => 'The comment has been saved!',
  'SAVE_SUCCESS_EDITCATEGORY' => 'The changes to the category have been saved!',
  'SAVE_SUCCESS_EDITROLL' => 'The changes to the user role have been saved!',
  'SAVE_SUCCESS_EDITUSER' => 'The changes to the user have been saved!',
  'SAVE_SUCCESS_EDITUSER_PROFILE' => 'The changes to your profile have been saved!',
  'SAVE_SUCCESS_FILE_ALTTEXT' => 'The alternative text was saved successfully.',
  'SAVE_SUCCESS_IPADDRESS' => 'The IP address has been blocked!',
  'SAVE_SUCCESS_IPADDRESS_CHG' => 'The changes to the IP address blocking have been saved!',
  'SAVE_SUCCESS_OPTIONS' => 'The changes to the configuration have been saved!',
  'SAVE_SUCCESS_PERMISSIONS' => 'The changes to the permissions have been saved!',
  'SAVE_SUCCESS_RESETPROFILE' => 'The user settings have been reset to the default values!',
  'SAVE_SUCCESS_SMILEY' => 'The smiley has been saved!',
  'SAVE_SUCCESS_TEMPLATE' => 'The template {{filename}} has been saved!<br>',
  'SAVE_SUCCESS_UPLOADAUTHORIMG' => 'The avatar has been uploaded!',
  'SAVE_SUCCESS_UPLOADMODULE' => 'The module package file has been uploaded!',
  'SAVE_SUCCESS_UPLOADPHP' => 'The files have been uploaded!<br>{{filenames}}',
  'SAVE_SUCCESS_UPLOADTPLFILE' => 'The template has been uploaded!',
  'SAVE_SUCCESS_USER_DISABLE' => 'The user has been disabled!',
  'SAVE_SUCCESS_USER_ENABLE' => 'The user has been enabled!',
  'SAVE_SUCCESS_WORDBAN' => 'The term was saved!',
  'SEARCH_ERROR' => 'The search could not be performed because the filter conditions are incorrect. Please check them again for missing links etc.',
  'SEARCH_WAITMSG' => 'Please wait 10 seconds before performing a new search.',
  'SELECT_ITEMS_MSG' => 'Please select elements or an action!',
  'SESSION_TIMEOUT' => 'It was detected that your current session has expired. Do you want to go to the login page? (select "No" to stay on the current page)',
  'SUCCESS_FILES_NEWTHUMBS' => 'New thumbnails were created!<br>{{filenames}}',
  'SYSCHECK_COMPLETE' => 'Full system check',
  'SYSCHECK_FOLDER_BACKUP' => 'Backup folder',
  'SYSCHECK_FOLDER_CACHE' => 'Cache folder',
  'SYSCHECK_FOLDER_CONFIG' => 'Config folder',
  'SYSCHECK_FOLDER_DATA' => 'Data folder',
  'SYSCHECK_FOLDER_DBDUMP' => 'Database backup folder',
  'SYSCHECK_FOLDER_DBSTRUCT' => 'Database structure files folder',
  'SYSCHECK_FOLDER_DRAFTS' => 'Drafts folder',
  'SYSCHECK_FOLDER_FILEMANAGER' => 'File manager temp folder',
  'SYSCHECK_FOLDER_LOGS' => 'Logs folder',
  'SYSCHECK_FOLDER_MODULES' => 'Modules folder',
  'SYSCHECK_FOLDER_OPTIONS' => 'Options folder',
  'SYSCHECK_FOLDER_PROFILES' => 'Profile folder structure',
  'SYSCHECK_FOLDER_SHARE' => 'Share button folder',
  'SYSCHECK_FOLDER_SMILEYS' => 'Smiley folder',
  'SYSCHECK_FOLDER_STYLES' => 'Template order',
  'SYSCHECK_FOLDER_TEMP' => 'Temporary files folder',
  'SYSCHECK_FOLDER_UPLOADS' => 'Upload folder',
  'SYSTEM_CHECK' => '{{icon="medkit"}} System check',
  'SYSTEM_CHECK_CONNECT' => 'Connect to other servers',
  'SYSTEM_HL_OPTIONS_ARTICLES' => 'Articles',
  'SYSTEM_HL_OPTIONS_EDITOR' => 'Editor and File manager',
  'SYSTEM_HL_OPTIONS_GENERAL' => 'General',
  'SYSTEM_HL_OPTIONS_SECURITY' => 'Security and maintenance',
  'SYSTEM_HL_OPTIONS_SYSCHECK' => 'System check',
  'SYSTEM_HL_OPTIONS_TWITTER' => 'Twitter connection',
  'SYSTEM_OPTIONS_ACPARTICLES_LIMIT' => 'Number of elements per page in ACP',
  'SYSTEM_OPTIONS_ACTIVECOMMENTTEMPLATE' => 'Comment template',
  'SYSTEM_OPTIONS_ACTIVENEWSTEMPLATE' => 'Template for article list',
  'SYSTEM_OPTIONS_ACTIVENEWSTEMPLATESINGLE' => 'Template for single article',
  'SYSTEM_OPTIONS_ANTISPAMANSWER' => 'Captcha question answer',
  'SYSTEM_OPTIONS_ANTISPAMQUESTION' => 'Captcha question',
  'SYSTEM_OPTIONS_ARCHIVE_LINK' => 'Show archive link',
  'SYSTEM_OPTIONS_BACKDROP_IMAGE' => 'Backdrop image',
  'SYSTEM_OPTIONS_CACHETIMEOUT' => 'Time until cache timeout',
  'SYSTEM_OPTIONS_CAPTCHASETTING' => 'Captcha settings',
  'SYSTEM_OPTIONS_COMMENTEMAIL' => 'Email address required',
  'SYSTEM_OPTIONS_COMMENTFORMTEMPLATE' => 'Comment form template',
  'SYSTEM_OPTIONS_COMMENT_APPROVE' => 'Comment approval required',
  'SYSTEM_OPTIONS_COMMENT_DEFAULT_ACTIVE' => 'Comments are enabled by default for articles',
  'SYSTEM_OPTIONS_COMMENT_ENABLED_GLOBAL' => 'Comment system is active',
  'SYSTEM_OPTIONS_COMMENT_MARKSPAM_PASTCHECK' => 'Automatic spam flagging',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY' => 'Comment notification to',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY_ALL' => 'global email address and author',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY_AUTHOR' => 'author only',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY_GLOBAL' => 'global email address',
  'SYSTEM_OPTIONS_COMMENT_PRIVACYOPTIN' => 'Consent to privacy policy required',
  'SYSTEM_OPTIONS_CRONJOBS' => 'Asynchronous cron job execution inactive',
  'SYSTEM_OPTIONS_DARKMODE' => 'Use dark mode',
  'SYSTEM_OPTIONS_DATETIMEMASK' => 'Date and time mask',
  'SYSTEM_OPTIONS_DATETIMEMASK_HELP' => 'Syntax corresponds to date() function of PHP',
  'SYSTEM_OPTIONS_EMAIL_ACTIVE' => 'Check of the access data was successful. E-mail is sent via SMTP.',
  'SYSTEM_OPTIONS_EMAIL_AUTHTYPE' => 'Authentication type',
  'SYSTEM_OPTIONS_EMAIL_CHECK' => 'Check SMTP connection',
  'SYSTEM_OPTIONS_EMAIL_ENABLED' => 'Send emails via SMTP',
  'SYSTEM_OPTIONS_EMAIL_ENCRYPTED' => 'SMTP encryption',
  'SYSTEM_OPTIONS_EMAIL_OAUTH' => 'Execute OAuth-authentication',
  'SYSTEM_OPTIONS_EMAIL_PASSWORD' => 'SMTP password',
  'SYSTEM_OPTIONS_EMAIL_PORT' => 'SMTP server port',
  'SYSTEM_OPTIONS_EMAIL_SERVER' => 'SMTP server address',
  'SYSTEM_OPTIONS_EMAIL_USERNAME' => 'SMTP username',
  'SYSTEM_OPTIONS_EXTENDED_DEVUPDATES' => 'Show developer versions at update check',
  'SYSTEM_OPTIONS_EXTENDED_EMAILSUBMISSION' => 'E-mail dispatch',
  'SYSTEM_OPTIONS_EXTENDED_EMAILUPDATES' => 'Email notification when updates are available',
  'SYSTEM_OPTIONS_EXTENDED_UPDATES' => 'Update settings',
  'SYSTEM_OPTIONS_EXTENDED_UPDATESMANCHK' => 'Test interval, without external server connections',
  'SYSTEM_OPTIONS_FILEMANAGER_LIMIT' => 'Number of pictures per page',
  'SYSTEM_OPTIONS_FILEMANAGER_VIEW' => 'File manager view',
  'SYSTEM_OPTIONS_FILEMANAGER_VIEWCARDS' => 'Cards',
  'SYSTEM_OPTIONS_FILEMANAGER_VIEWLIST' => 'List',
  'SYSTEM_OPTIONS_FLOODPROTECTION' => 'Time lock between two comments',
  'SYSTEM_OPTIONS_INCLUDEJQUERY' => 'Load jQuery library into frontend',
  'SYSTEM_OPTIONS_INCLUDEJQUERY_YES' => 'Select &quot;yes&quot; if you have not yet included jQuery elsewhere in your site.',
  'SYSTEM_OPTIONS_LANG' => 'Language',
  'SYSTEM_OPTIONS_LATESTNEWSTEMPLATE' => '"Lastest news" template',
  'SYSTEM_OPTIONS_LOGIN_MAXATTEMPTS' => 'Number of login attempts before temporary lockout',
  'SYSTEM_OPTIONS_LOGIN_TWOFACTORAUTH' => 'Two factor authentication',
  'SYSTEM_OPTIONS_MAINTENANCE' => 'Maintenance mode active',
  'SYSTEM_OPTIONS_NEWSSHARECOUNT' => 'Count shared articles via share buttons',
  'SYSTEM_OPTIONS_NEWSSHOWIMGTHUMBSIZE' => 'Thumbnail size',
  'SYSTEM_OPTIONS_NEWSSHOWLIMIT' => 'Number of articles per public page',
  'SYSTEM_OPTIONS_NEWSSHOWMAXIMGSIZEHEIGHT' => 'Height in pixel',
  'SYSTEM_OPTIONS_NEWSSHOWMAXIMGSIZEWIDTH' => 'Width in pixel',
  'SYSTEM_OPTIONS_NEWSSHOWSHARELINKS' => 'Display share buttons',
  'SYSTEM_OPTIONS_NEWS_ARCHIVELIMIT' => 'Show articles in archive from',
  'SYSTEM_OPTIONS_NEWS_ARCHIVELIMIT_EMPTY' => 'Empty does not correspond to a limit',
  'SYSTEM_OPTIONS_NEWS_BYAUTHOR' => 'Author',
  'SYSTEM_OPTIONS_NEWS_BYEDITEDTIME' => 'Last modification',
  'SYSTEM_OPTIONS_NEWS_BYINTERNALID' => 'Internal ID',
  'SYSTEM_OPTIONS_NEWS_BYWRITTENTIME' => 'Publication',
  'SYSTEM_OPTIONS_NEWS_EDITOR' => 'Select editor',
  'SYSTEM_OPTIONS_NEWS_EDITOR_CLASSIC' => 'CodeMirror',
  'SYSTEM_OPTIONS_NEWS_EDITOR_CSS' => 'CSS classes in editor',
  'SYSTEM_OPTIONS_NEWS_EDITOR_FONTSIZE' => 'Default font size in editor',
  'SYSTEM_OPTIONS_NEWS_EDITOR_SETTINGS' => 'Editor settings',
  'SYSTEM_OPTIONS_NEWS_EDITOR_TINYMCE5' => 'TinyMCE 5',
  'SYSTEM_OPTIONS_NEWS_ENABLEFEED' => 'RSS feed is active',
  'SYSTEM_OPTIONS_NEWS_ORDERASC' => 'Ascending',
  'SYSTEM_OPTIONS_NEWS_ORDERDESC' => 'Descending',
  'SYSTEM_OPTIONS_NEWS_REVISIONS_LIMIT' => 'Delete old revisions if older than',
  'SYSTEM_OPTIONS_NEWS_SORTING' => 'Sort articles by',
  'SYSTEM_OPTIONS_NEWS_SORTING_ORDER' => 'Order is',
  'SYSTEM_OPTIONS_NEWS_SOURCESLIST' => 'List of sources',
  'SYSTEM_OPTIONS_NEWS_SUBFOLDERS' => 'Organize files into sub-folders when uploading',
  'SYSTEM_OPTIONS_NEWS_URLREWRITING' => 'Enable URL rewriting for article links',
  'SYSTEM_OPTIONS_REVISIONS_ENABLED' => 'Enable revisions',
  'SYSTEM_OPTIONS_SESSIONLENGHT' => 'Maximum length of an admin session',
  'SYSTEM_OPTIONS_STYLESHEET' => 'Path to your CSS file',
  'SYSTEM_OPTIONS_SYSCHECK_CACHE' => 'Cache-Backend',
  'SYSTEM_OPTIONS_SYSCHECK_CACHE_FSBACKEND' => 'File system',
  'SYSTEM_OPTIONS_SYSCHECK_CACHE_MEMCACHEBACKEND' => 'Memcache (experimental)',
  'SYSTEM_OPTIONS_SYSCHECK_CURRENT' => 'Current',
  'SYSTEM_OPTIONS_SYSCHECK_DBDRV_ACTIVE' => 'Active database driver',
  'SYSTEM_OPTIONS_SYSCHECK_DBDRV_MYSQL' => 'MySQL/ MariaDB database driver available',
  'SYSTEM_OPTIONS_SYSCHECK_DBDRV_PGSQL' => 'Postgres database driver available',
  'SYSTEM_OPTIONS_SYSCHECK_DBVERSION' => 'Version of the database system >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_FPCMVERSION' => 'FanPress CM Version = {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_HTTPS' => 'HTTPS is active',
  'SYSTEM_OPTIONS_SYSCHECK_MEMCACHE' => 'Memcache active',
  'SYSTEM_OPTIONS_SYSCHECK_OPCACHE' => 'OPcache enabled',
  'SYSTEM_OPTIONS_SYSCHECK_PHPMAXEXECTIME' => 'Maximum execution time for PHP >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_PHPMEMLIMIT' => 'PHP memory limit >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_PHPVERSION' => 'PHP version >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_SUBMITSTATS' => 'Submit statistical data',
  'SYSTEM_OPTIONS_TIMEZONE' => 'Timezone',
  'SYSTEM_OPTIONS_TRASH_CLEANUP_DAYS' => 'Retention time for deleted elements',
  'SYSTEM_OPTIONS_TWITTER_ACTIVE' => 'Twitter connection is active! Connected to user "{{screenname}}".',
  'SYSTEM_OPTIONS_TWITTER_CONNECT' => 'Request API key or token',
  'SYSTEM_OPTIONS_TWITTER_CONSTATE' => 'Connection status',
  'SYSTEM_OPTIONS_TWITTER_CONSUMER_KEY' => 'Consumer Key (API Key)',
  'SYSTEM_OPTIONS_TWITTER_CONSUMER_SECRET' => 'Consumer Secret (API Secret)',
  'SYSTEM_OPTIONS_TWITTER_CREDENTIALS' => 'Login data',
  'SYSTEM_OPTIONS_TWITTER_DISCONNECT' => 'Delete connection',
  'SYSTEM_OPTIONS_TWITTER_EVENTCREATE' => 'Publish',
  'SYSTEM_OPTIONS_TWITTER_EVENTS' => 'Generate tweet to article at',
  'SYSTEM_OPTIONS_TWITTER_EVENTTIMELINE' => 'Fetch tweet timeline',
  'SYSTEM_OPTIONS_TWITTER_EVENTUPDATE' => 'Update',
  'SYSTEM_OPTIONS_TWITTER_USER_SECRET' => 'Access Token Secret',
  'SYSTEM_OPTIONS_TWITTER_USER_TOKEN' => 'Access Token',
  'SYSTEM_OPTIONS_URL' => 'Base URL for article links',
  'SYSTEM_OPTIONS_USEMODE' => 'Usage per',
  'SYSTEM_OPTIONS_USEMODE_IFRAME' => 'iframe',
  'SYSTEM_OPTIONS_USEMODE_PHPINCLUDE' => 'phpinclude',
  'SYSTEM_OPTIONS_USERS_PASSCHECK' => 'Check user passwords against haveibeenpwned.com/passwords service',
  'SYSTEM_STATS' => '{{icon="chart-bar"}} Statistics',
  'SYSTEM_STATS_ARTICLES_ACTIVE' => 'Article active',
  'SYSTEM_STATS_ARTICLES_ALL' => 'Total articles',
  'SYSTEM_STATS_ARTICLES_APPROVAL' => 'Articles to be approved',
  'SYSTEM_STATS_ARTICLES_ARCHIVE' => 'Articles archived',
  'SYSTEM_STATS_ARTICLES_DRAFT' => 'Article drafts',
  'SYSTEM_STATS_ARTICLES_POSTPONED' => 'Postponed articles',
  'SYSTEM_STATS_CACHE_SIZE' => 'Cache size',
  'SYSTEM_STATS_CATEGORIES' => 'Categories',
  'SYSTEM_STATS_COMMENTS_ALL' => 'Comments total',
  'SYSTEM_STATS_COMMENTS_PRIVATE' => 'Comments private',
  'SYSTEM_STATS_COMMENTS_SPAM' => 'Spam comments',
  'SYSTEM_STATS_COMMENTS_UNAPPR' => 'Comments not approved',
  'SYSTEM_STATS_TRASHCOUNT' => 'Deleted elements',
  'SYSTEM_STATS_UPLOAD_COUNT' => 'Uploaded files',
  'SYSTEM_STATS_UPLOAD_SIZE' => 'Upload folder size',
  'SYSTEM_STATS_USERS' => 'Users (thereof active)',
  'SYSTEM_UPDATE' => '{{icon="sync"}} Available updates',
  'TEMPLATE_ARTICLE_ARTICLEIMAGE' => 'Article image',
  'TEMPLATE_ARTICLE_AUTHOR' => 'Article author',
  'TEMPLATE_ARTICLE_AUTHORAVATAR' => 'Avatar of article author',
  'TEMPLATE_ARTICLE_AUTHOREMAIL' => 'Article author with linked email address',
  'TEMPLATE_ARTICLE_AUTHORINFOTEXT' => 'short text with info about the article author',
  'TEMPLATE_ARTICLE_CATEGORYICONS' => 'Category icons',
  'TEMPLATE_ARTICLE_CATEGORYTEXTS' => 'Categories',
  'TEMPLATE_ARTICLE_CHANGEDATE' => 'Date and time of last change',
  'TEMPLATE_ARTICLE_CHANGEUSER' => 'User of the last modification',
  'TEMPLATE_ARTICLE_COMMENTCOUNT' => 'Comment count',
  'TEMPLATE_ARTICLE_COMMENTLINK' => 'Comment link',
  'TEMPLATE_ARTICLE_DATE' => 'Date and time',
  'TEMPLATE_ARTICLE_HEADLINE' => 'Headline',
  'TEMPLATE_ARTICLE_OLDARTICLE' => 'Notice to old article',
  'TEMPLATE_ARTICLE_PERMALINK' => 'Article link',
  'TEMPLATE_ARTICLE_SHAREBUTTONS' => 'Share buttons',
  'TEMPLATE_ARTICLE_SHORTLINK' => 'Short link',
  'TEMPLATE_ARTICLE_SOURCES' => 'List of sources',
  'TEMPLATE_ARTICLE_STATUSPINNED' => 'Notice that news is pinned',
  'TEMPLATE_ARTICLE_TEXT' => 'Article text',
  'TEMPLATE_ARTICLE_TEXTSHORT' => 'Short version of the article text, use of {{pagebreakVar}} possible.',
  'TEMPLATE_ATTRIBUTES' => 'Available attributes',
  'TEMPLATE_COMMMENTFORM_EMAILDESCRIPTION' => 'Field description "Email"',
  'TEMPLATE_COMMMENTFORM_EMAILFIELD' => '"Email" field',
  'TEMPLATE_COMMMENTFORM_FORMHEADLINE' => 'Comment form headline',
  'TEMPLATE_COMMMENTFORM_NAMEDESCRIPTION' => 'Field description "Name"',
  'TEMPLATE_COMMMENTFORM_NAMEFIELD' => 'Field "Name"',
  'TEMPLATE_COMMMENTFORM_PRIVACYCOMFIRMATION' => 'Checkbox for additional privacy policy consent',
  'TEMPLATE_COMMMENTFORM_PRIVATECHECKBOX' => 'Checkbox for private comment',
  'TEMPLATE_COMMMENTFORM_RESETBUTTON' => 'Reset button',
  'TEMPLATE_COMMMENTFORM_SMILEYS' => 'Smileys',
  'TEMPLATE_COMMMENTFORM_SMILEYSDESCRIPTION' => '"Smiley" description',
  'TEMPLATE_COMMMENTFORM_SPAMPLUGINFIELD' => 'Anti spam plugin reply field',
  'TEMPLATE_COMMMENTFORM_SPAMPLUGINQUESTION' => 'Anti spam plugin question',
  'TEMPLATE_COMMMENTFORM_SUBMITBUTTON' => 'Submit button',
  'TEMPLATE_COMMMENTFORM_SUBMITURL' => 'URL of the comment form <b>(important!)</b>',
  'TEMPLATE_COMMMENTFORM_TAGS' => 'Allowed HTML tags in comment',
  'TEMPLATE_COMMMENTFORM_TEXTFIELD' => 'Textarea for comment text',
  'TEMPLATE_COMMMENTFORM_WEBSITEDESCRIPTION' => 'Field description "Website"',
  'TEMPLATE_COMMMENTFORM_WEBSITEFIELD' => 'Field "Website"',
  'TEMPLATE_COMMMENT_AUTHOR' => 'Comment author',
  'TEMPLATE_COMMMENT_DATE' => 'Date and time',
  'TEMPLATE_COMMMENT_EMAIL' => 'Author email',
  'TEMPLATE_COMMMENT_ID' => 'Comment ID',
  'TEMPLATE_COMMMENT_MENTION' => 'Link to respond to comment',
  'TEMPLATE_COMMMENT_MENTIONID' => 'ID to use <i>{{mention}}:{{/mention}}</i>.',
  'TEMPLATE_COMMMENT_NUMBER' => 'Comment number',
  'TEMPLATE_COMMMENT_TEXT' => 'Comment text',
  'TEMPLATE_COMMMENT_WEBSITE' => 'Author\'s website',
  'TEMPLATE_EDITOR' => 'Template editor',
  'TEMPLATE_HL_ARTICLES' => 'Article list',
  'TEMPLATE_HL_ARTICLE_SINGLE' => 'Article single view',
  'TEMPLATE_HL_COMMENTFORM' => 'Comment form',
  'TEMPLATE_HL_COMMENTS' => 'Comment',
  'TEMPLATE_HL_DRAFTS' => 'Article templates',
  'TEMPLATE_HL_DRAFTS_EDIT' => 'Edit article template',
  'TEMPLATE_HL_LATESTNEWS' => 'Latest News',
  'TEMPLATE_HL_SHAREBUTTONS' => 'Share buttons',
  'TEMPLATE_HL_TWEET' => 'Tweet',
  'TEMPLATE_NOT_WRITABLE' => 'The selected template is not writable, please check the permissions on the server.',
  'TEMPLATE_REPLACEMENTS' => 'Usable placeholders',
  'TEMPLATE_SHAREBUTTONS_ARTICLEID' => 'Article ID (for own buttons)',
  'TEMPLATE_SHAREBUTTONS_CREDITS' => 'Credit tag for icons, etc.',
  'TEMPLATE_SHAREBUTTONS_DESCRIPTION' => 'Description (for own buttons)',
  'TEMPLATE_SHAREBUTTONS_EMAIL' => 'Button for E-Mail',
  'TEMPLATE_SHAREBUTTONS_FACEBOOK' => 'Button for Facebook',
  'TEMPLATE_SHAREBUTTONS_LIKEBUTTON' => 'Button to like an article, does not use external services. Warning! This button requires "Count shared articles via share buttons" to be active!',
  'TEMPLATE_SHAREBUTTONS_LINK' => 'Ziel-Link (for eigene Buttons)',
  'TEMPLATE_SHAREBUTTONS_PINTEREST' => 'Button for Pinterest',
  'TEMPLATE_SHAREBUTTONS_REDDIT' => 'Button for Reddit',
  'TEMPLATE_SHAREBUTTONS_TELEGRAM' => 'Button for Telegram',
  'TEMPLATE_SHAREBUTTONS_TUMBLR' => 'Button for Tumblr',
  'TEMPLATE_SHAREBUTTONS_TWITTER' => 'Button for Twitter',
  'TEMPLATE_SHAREBUTTONS_WHATSAPP' => 'Button for WhatsApp',
  'UPDATE_MODULECHECK_CURRENT' => 'All installed modules are <strong>up-to-date</strong>!',
  'UPDATE_MODULECHECK_FAILED' => 'No update check could be performed for the installed modules!',
  'UPDATE_MODULECHECK_NEW' => 'Updates are available for some modules. {{btn}}',
  'UPDATE_NOTAUTOCHECK' => 'No automatic update check could be performed! {{btn}}',
  'UPDATE_VERSIONCECK_FILEDB_ERR' => 'The version in the file system and the database do not match. {{btn}}',
  'UPDATE_VERSIONCECK_FILETXT_ERR' => 'The file <em>/data/config/files.txt</em> was not found. This should not happen and can lead to unpredictable behavior.',
  'UPDATE_VERSIONCECK_FILETXT_ERR2' => 'The /config/files.txt file was not found for this module. This should not happen and can lead to unpredictable behavior.',
  'UPDATE_VERSIONCHECK_CURRENT' => 'Your version of FanPress CM is <strong>up to date</strong>!',
  'UPDATE_VERSIONCHECK_NEW' => 'FanPress CM version <i>{{version}}</i> is available! {{btn}}',
  'UPDATE_VERSIONCHECK_NOTES' => 'Release notes and more information about system and module updates can be found in the current FanPress CM News.',
  'UPDATE_WRITEERROR' => 'Some files in the file system are not writable and therefore cannot be replaced. Check the permissions of the files via FTP, you can find a list in the system log.',
  'USERS_ADD' => 'Add user',
  'USERS_ARTICLES_SELECT' => 'Please select what should happen with articles of this user',
  'USERS_ARTICLES_USER' => 'Select user',
  'USERS_ARTICLE_COUNT' => 'Article count',
  'USERS_AUTHTOKEN_ACTIVE' => 'Two-factor authentication is active.',
  'USERS_AUTHTOKEN_SAVE' => 'Numerical code for activation',
  'USERS_AVATAR' => 'Avatar',
  'USERS_BIOGRAPHY' => 'Biography / Miscellaneous',
  'USERS_DISABLED' => 'User was disabled',
  'USERS_DISPLAYNAME' => 'Displayed name',
  'USERS_EDIT' => 'Edit user',
  'USERS_EDIT_PERMISSION' => 'Edit permissions: {{rollname}}',
  'USERS_LIST' => 'User',
  'USERS_LIST_ROLLS' => 'Roles',
  'USERS_META_OPTIONS' => 'User settings',
  'USERS_META_RESET_DASHBOARD' => 'Reset container positions',
  'USERS_PASSGEN' => 'Generate password',
  'USERS_PASSWORD_CONFIRM' => 'Confirm password',
  'USERS_PASSWORD_SENDUSERINFO' => 'Notify user about new password',
  'USERS_REGISTEREDTIME' => 'Registered on',
  'USERS_REQUIREMENTS' => 'Password must contain at least 6 characters, upper and lower case letters and numbers.',
  'USERS_ROLL' => 'Role',
  'USERS_ROLLS_CODEX' => 'Codex',
  'USERS_ROLLS_NAME' => 'Role name',
  'USERS_ROLLS_PERMISSIONS' => 'Edit permissions of the role',
  'USERS_ROLL_ADD' => 'Add role',
  'USERS_ROLL_EDIT' => 'Edit role',
  'USERS_SENDUSERINFO' => 'Notify user',
  'USERS_STATS_ARTICLE' => 'Article statistics',
  'USERS_SYSTEMUSER' => 'FPCM system',
  'VERSION' => 'Version',
  'VIEW_NOT_FOUND' => 'The view {{viewname}} was not found!',
  'WELCOME_CONTENT' => 'You are in the dashboard of FanPress CM, the news system especially for fansites.<br>Use the navigation on the left to get to the different sections.<br><br>Following you will find some statistics and more information about the current system.',
  'WELCOME_HEADLINE' => '{{icon="user"}} Welcome {{username}}!',
  'WORDBAN_ADD' => 'Add term',
  'WORDBAN_APPROVA_COMMENT' => 'Comment must be approved',
  'WORDBAN_APPROVE_ARTICLE' => 'Article must be reviewed',
  'WORDBAN_EDIT' => 'Edit term',
  'WORDBAN_FORM' => 'Settings for this text',
  'WORDBAN_NAME' => 'Term',
  'WORDBAN_REPLACEMENT_TEXT' => 'Replacement',
  'WORDBAN_REPLACETEXT' => 'Replace text',
);
