<?php

/**
 * FanPress CM language variables file: de
 * @author Stefan Seehafer <sea75300@yahoo.de>
 * @copyright (c) 2011-2025, Stefan Seehafer
 * @license http://www.gnu.org/licenses/gpl.txt GPLv3
 */

$lang = array (
  'AJAX_REQUEST_ERROR' => 'Beim Ausführen der Aktion ist ein Fehler aufgetreten! Weitere Informationen findest du im Javascript-Log deines Browsers.',
  'AJAX_RESPONSE_ERROR' => 'Vom Server wurde eine ungültige Antwort geliefert! Weitere Informationen findest du im Javascript-Log deines Browsers und ggf. im PHP-Log.',
  'ARTICLELIST_ERROR' => 'Die Liste konnte nicht geladen werden, da ein Fehler beim Abruf der Daten aufgetreten ist.',
  'ARTICLES_CACHE_CLEAR' => 'Artikel-Cache leeren',
  'ARTICLES_EDITOR' => 'Artikel-Editor',
  'ARTICLES_PUBLIC_ACTIVE' => 'zu aktuellen Artikeln',
  'ARTICLES_PUBLIC_ARCHIVE' => 'Archiv öffnen',
  'ARTICLES_PUBLIC_READMORE' => 'weiterlesen',
  'ARTICLES_SEARCH' => 'Suche & Filter',
  'ARTICLES_TRASH' => 'Papierkorb',
  'ARTICLE_LIST_COMMENTNOTICE' => 'Artikel besitzt nicht genehmigte oder private Kommentare',
  'ARTICLE_LIST_EMPTYTRASH' => 'Papierkorb leeren',
  'ARTICLE_LIST_NEWTWEET' => 'Neuen Tweet erzeugen',
  'ARTICLE_LIST_RESTOREARTICLE' => 'Elemente wiederherstellen',
  'ARTICLE_LIST_TITLE' => 'Titel',
  'ARTICLE_SEARCH_APPROVAL' => 'freizuschaltende Artikel',
  'ARTICLE_SEARCH_CATEGORY' => 'Kategorie einschränken',
  'ARTICLE_SEARCH_COMMENTS' => 'Kommentare aktiv',
  'ARTICLE_SEARCH_DATE_FROM' => 'Datum von',
  'ARTICLE_SEARCH_DATE_TO' => 'Datum bis',
  'ARTICLE_SEARCH_DRAFT' => 'Entwürfe',
  'ARTICLE_SEARCH_LOGIC' => 'Verknüpfung',
  'ARTICLE_SEARCH_LOGICAND' => 'UND',
  'ARTICLE_SEARCH_LOGICNONE' => 'keine',
  'ARTICLE_SEARCH_LOGICOR' => 'ODER',
  'ARTICLE_SEARCH_PINNED' => 'gepinnte Artikel',
  'ARTICLE_SEARCH_POSTPONED' => 'geplante Artikel',
  'ARTICLE_SEARCH_START' => 'Suche starten...',
  'ARTICLE_SEARCH_TEXT' => 'Nach diesem Text suchen',
  'ARTICLE_SEARCH_TYPE_ALL' => 'Titel UND Text',
  'ARTICLE_SEARCH_TYPE_ALLOR' => 'Titel ODER Text',
  'ARTICLE_SEARCH_TYPE_TEXT' => 'nur Text',
  'ARTICLE_SEARCH_TYPE_TITLE' => 'nur Titel',
  'ARTICLE_SEARCH_USER' => 'Benutzer einschränken',
  'BACKUPS_NOTICE_POSTGRES' => 'Die automatische Sicherung der Datenbank wird Postgres aktuell nicht unterstützt.',
  'CACHE_CLEARED_OK' => 'Der Cache wurde geleert!',
  'CATEGORIES_ADD' => 'Kategorie hinzufügen',
  'CATEGORIES_EDIT' => 'Kategorie bearbeiten',
  'CATEGORIES_ICON_PATH' => 'Kategorie-Icon',
  'CATEGORIES_NAME' => 'Kategorie-Name',
  'CATEGORIES_ROLLS' => 'Verfügbar für Rollen',
  'COMMENTS_EDIT' => 'Kommentar bearbeiten',
  'COMMENTS_EDITARTICLE' => 'Zugehörigen Artikel bearbeiten',
  'COMMENTS_NOTIFICATION_NEW_COUNT' => 'Es gibt %s neue Kommentare.',
  'COMMENTS_PUBLIC_FORMHEADLINE' => 'Hinterlasse einen Kommentar',
  'COMMENTS_SEARCH_TYPE_ALL' => 'Alles UND',
  'COMMENTS_SEARCH_TYPE_ALLOR' => 'Alles ODER',
  'COMMENTS_SEARCH_TYPE_NAMEMAILWEB' => 'Name, E-Mail UND Webseite',
  'COMMENTS_SEARCH_TYPE_NAMEMAILWEB_OR' => 'Name, E-Mail ODER Webseite',
  'COMMENTS_SEARCH_TYPE_TEXT' => 'nur Text durchsuchen',
  'COMMMENT_APPROVE' => 'Kommentar ist genehmigt',
  'COMMMENT_AUTHOR' => 'Name',
  'COMMMENT_CREATEDATE' => 'Geschrieben am',
  'COMMMENT_HEADLINE' => 'Kommentare',
  'COMMMENT_IMPORT_ARTICLEID' => 'Artikel-ID',
  'COMMMENT_IPADDRESS' => 'IP-Adresse des Autors',
  'COMMMENT_LOCKIP' => 'IP-Adresse sperren',
  'COMMMENT_MOVE' => 'Kommentar zu Artikel verschieben',
  'COMMMENT_PRIVATE' => 'Kommentar ist privat',
  'COMMMENT_SEARCH_ARTICLE' => 'Suche in Artikel mit ID',
  'COMMMENT_SPAM' => 'Kommentar ist Spam',
  'COMMMENT_STATUS' => 'Status',
  'COMMMENT_TEXT' => 'Kommentar-Text',
  'COMMMENT_WEBSITE' => 'Webseite',
  'CONFIRM_MESSAGE' => 'Willst du diese Aktion wirklich durchführen?',
  'CRONJOB_ANONYMIZEIPS' => 'IP-Adressen aus Kommentaren anonymisieren',
  'CRONJOB_BTN_CANCEL' => 'Cronjob beenden und freigeben',
  'CRONJOB_CLEANUPTRASH' => 'Papierkorb bereinigen',
  'CRONJOB_CLEARLOGS' => 'System-Protokolle leeren',
  'CRONJOB_CLEARTEMP' => 'temporäre Dateien aufräumen',
  'CRONJOB_DBBACKUP' => 'System-Datenbank sichern',
  'CRONJOB_DBBACKUPS_SUBJECT' => 'Datenbank-Sicherung wurde erzeugt',
  'CRONJOB_DBBACKUPS_TEXT' => 'Um {{filetime}} wurde durch den Cronjob eine Sicherung der FanPress CM Datenbank-Tabellen erzeugt. Die Datei findest du unter {{dumpfile}} und als Anhang an dieser E-Mail.',
  'CRONJOB_ECEDUTING' => 'Cronjob <em>{{cjname}}</em> wird ausgeführt, bitte warten...',
  'CRONJOB_FILEINDEX' => 'Dateiindex neu aufbauen',
  'CRONJOB_FMTHUMBS' => 'Dateimanager-Thumbnails erzeugen',
  'CRONJOB_LIST_EXECDEMAND' => 'Cronjob jetzt ausführen',
  'CRONJOB_LIST_INTERVAL' => 'Intervall',
  'CRONJOB_LIST_LASTEXEC' => 'Zuletzt ausgeführt',
  'CRONJOB_LIST_NAME' => 'Bezeichnung',
  'CRONJOB_LIST_NEXTEXEC' => 'nächste Ausführung',
  'CRONJOB_MAIL_SUBJECT_POSTPONEDARTICLES' => 'Geplante Artikel wurden veröffentlicht',
  'CRONJOB_POSTPONEDARTICLES' => 'geplante Artikel veröffentlichen',
  'CRONJOB_REMOVEREVISIONS' => 'Artikel-Revisionen bereinigen',
  'CRONJOB_UNPINARTICLES' => 'Artikel nach Datum abpinnen',
  'CRONJOB_UPDATECHECK' => 'Prüfung auf Updates',
  'CRONJOB_UPDATES_NEWVERSION' => 'Neue FanPress CM Version verfügbar',
  'CRONJOB_UPDATES_NEWVERSION_TEXT' => 'Es ist eine neue Version {{version}} von FanPress CM verfügbar. Bitte melde dich im ACP an, um das Update durchzuführen.

{{acplink}}',
  'CSRF_INVALID' => 'Das CSRF-Token ist ungültig. Die Aktion wurde nicht durchgeführt!',
  'DASHBOARD_LOADING' => 'Dashboard-Container werden geladen',
  'DASHBOARD_MANAGE_CONTAINER' => 'Container verwalten',
  'DASHBOARD_MANAGE_CONTAINER_ENABLE' => '{{icon="box"}} Container reaktivieren',
  'DASHBOARD_USERLIST' => '{{icon="users"}} Team-Kontakte',
  'DEBUG_MODE' => 'Debug-Modus aktiv',
  'DELETE_FAILED_ARTICLE' => 'Die Artikel konnten nicht gelöscht werden!',
  'DELETE_FAILED_CATEGORIES' => 'Die Kategorien konnten nicht gelöscht werden!',
  'DELETE_FAILED_COMMENTS' => 'Die Kommentare konnten nicht gelöscht werden!',
  'DELETE_FAILED_FILEAUTHORIMG' => 'Der Avatar konnte nicht gelöscht werden!',
  'DELETE_FAILED_FILES' => 'Die Dateien konnten nicht gelöscht werden!<br>{{filenames}}',
  'DELETE_FAILED_IPADDRESS' => 'Die IP-Adresse konnten nicht gelöscht werden!',
  'DELETE_FAILED_REVISIONS' => 'Die Revisionen konnten nicht gelöscht werden!',
  'DELETE_FAILED_ROLL' => 'Die Benutzerrolle konnte nicht gelöscht werden!',
  'DELETE_FAILED_ROLL_LAST' => 'Die letzte Rolle kann nicht gelöscht werden!',
  'DELETE_FAILED_ROLL_OWN' => 'Du kannst deine eigene Rolle nicht löschen!',
  'DELETE_FAILED_SMILEYS' => 'Die Smileys konnten nicht gelöscht werden!',
  'DELETE_FAILED_TRASH' => 'Der Papierkorb konnte nicht geleert werden!',
  'DELETE_FAILED_USERS' => 'Der Benutzer konnte nicht gelöscht werden!',
  'DELETE_FAILED_USERSARTICLES' => 'Artikel können nicht zum zu löschenden Benutzer verschoben werden!',
  'DELETE_FAILED_USERS_LAST' => 'Der letzte Benutzer kann nicht gelöscht werden!',
  'DELETE_FAILED_USERS_OWN' => 'Du kannst deinen eigenen Account nicht löschen!',
  'DELETE_FAILED_WORDBAN' => 'Die Begriffe konnten nicht gelöscht werden!',
  'DELETE_SUCCESS_CATEGORIES' => 'Die Kategorien wurden gelöscht!',
  'DELETE_SUCCESS_COMMENTS' => 'Die Kommentare wurden gelöscht!',
  'DELETE_SUCCESS_FILEAUTHORIMG' => 'Der Avatar wurde gelöscht!',
  'DELETE_SUCCESS_FILES' => 'Die Dateien wurden gelöscht!<br>{{filenames}}',
  'DELETE_SUCCESS_IPADDRESS' => 'Die IP-Adressen wurde(n) gelöscht!',
  'DELETE_SUCCESS_RENAME' => 'Die Datei wurde {{filename1}} in {{filename2}} umbenannt!',
  'DELETE_SUCCESS_REVISIONS' => 'Die Revisionen wurden gelöscht!',
  'DELETE_SUCCESS_ROLL' => 'Die Benutzerrolle wurden gelöscht!',
  'DELETE_SUCCESS_SMILEYS' => 'Die Smileys wurden gelöscht!',
  'DELETE_SUCCESS_TRASH' => 'Der Papierkorb wurde geleert!',
  'DELETE_SUCCESS_USERS' => 'Der Benutzer wurden gelöscht!',
  'DELETE_SUCCESS_WORDBAN' => 'Die Begriffe wurden gelöscht!',
  'DEPRECATED_TWITTER_BUILDIN' => 'Die integrierte Twitter-Anbindung wird in einem der nächsten Updates entfernt! Details folgen in den Releasenotes.',
  'EDITOR_ARCHIVE' => 'Artikel archivieren',
  'EDITOR_ARTICLEIMAGE' => 'Artikelbild festlegen',
  'EDITOR_ARTICLEIMAGE_SHOW' => 'Artikelbild anzeigen',
  'EDITOR_ARTICLE_ARTICLELINK' => 'Text für Artikellinks ("{{articleId}}-" +)',
  'EDITOR_ARTICLE_SHORTLINK' => 'Kurzlink',
  'EDITOR_ARTICLE_SHORTLINK_COPY' => 'Link kopieren',
  'EDITOR_AUTOSAVE_RESTORE' => 'Letzten Entwurf wiederherstellen',
  'EDITOR_BACKTOCURRENT' => 'Zurück zur aktuellen Version',
  'EDITOR_CATEGORIES_SEARCH' => 'Kategorien suchen und auswählen...',
  'EDITOR_CHANGEAUTHOR' => 'Autor ändern',
  'EDITOR_CODEX' => 'Der Codex für deine Rolle',
  'EDITOR_COMMENTS' => 'Kommentare aktiv',
  'EDITOR_COMMENTS_DELETE' => 'Kommentare löschen',
  'EDITOR_CSS_CLASS' => 'CSS-Klasse',
  'EDITOR_DRAFT' => 'Artikel ist Entwurf',
  'EDITOR_HTML_BUTTONS_ACENTER' => 'Zentriert',
  'EDITOR_HTML_BUTTONS_AJUSTIFY' => 'Blocksatz',
  'EDITOR_HTML_BUTTONS_ALEFT' => 'Linksbündig',
  'EDITOR_HTML_BUTTONS_ARIGHT' => 'Rechtsbündig',
  'EDITOR_HTML_BUTTONS_ARTICLETPL' => 'Vorlage einfügen',
  'EDITOR_HTML_BUTTONS_BOLD' => 'Fett',
  'EDITOR_HTML_BUTTONS_IFRAME' => 'iFrame einfügen',
  'EDITOR_HTML_BUTTONS_ITALIC' => 'Kursiv',
  'EDITOR_HTML_BUTTONS_LISTOL' => 'Nummerierte Liste',
  'EDITOR_HTML_BUTTONS_LISTUL' => 'Aufzählung',
  'EDITOR_HTML_BUTTONS_PAGEBREAK' => 'Seitenumbruch einfügen',
  'EDITOR_HTML_BUTTONS_QUOTE' => 'Zitat einfügen',
  'EDITOR_HTML_BUTTONS_QUOTE_BLOCK' => 'als Absatz',
  'EDITOR_HTML_BUTTONS_QUOTE_INLINE' => 'in Zeile',
  'EDITOR_HTML_BUTTONS_QUOTE_TEXT' => 'Zitat-Text',
  'EDITOR_HTML_BUTTONS_REMOVESTYLE' => 'HTML-Tags entfernen',
  'EDITOR_HTML_BUTTONS_STRIKE' => 'Durchgestrichen',
  'EDITOR_HTML_BUTTONS_SUB' => 'Tiefgestellt',
  'EDITOR_HTML_BUTTONS_SUP' => 'Hochgestellt',
  'EDITOR_HTML_BUTTONS_SYMBOL' => 'Symbol einfügen',
  'EDITOR_HTML_BUTTONS_UNDERLINE' => 'Unterstrichen',
  'EDITOR_IMGALIGN' => 'Ausrichtung',
  'EDITOR_IMGALTTXT' => 'Alternativtext',
  'EDITOR_IMGPATH' => 'Quelle',
  'EDITOR_IMGPATH_ALT' => 'Alternative Quelle',
  'EDITOR_INSERTCOLOR' => 'Farbe einfügen',
  'EDITOR_INSERTCOLOR_BACKGROUND' => 'als Hintergrundfarbe',
  'EDITOR_INSERTCOLOR_HEXCODE' => 'HTML-Farbcode',
  'EDITOR_INSERTCOLOR_TEXT' => 'als Schriftfarbe',
  'EDITOR_INSERTLINK' => 'Link einfügen',
  'EDITOR_INSERTLIST_TYPESIGN' => 'CSS list-style-type',
  'EDITOR_INSERTMEDIA' => 'Audio-/Video-Player einfügen',
  'EDITOR_INSERTMEDIA_AUDIO' => 'als Audio-Player',
  'EDITOR_INSERTMEDIA_AUTOPLAY' => 'Autoplay',
  'EDITOR_INSERTMEDIA_CONTROLS' => 'Kontrollelemente',
  'EDITOR_INSERTMEDIA_FORMAT_SELECT' => 'Medien-Format auswählen',
  'EDITOR_INSERTMEDIA_POSTER' => 'Vorschau-Bild',
  'EDITOR_INSERTMEDIA_VIDEO' => 'als Video-Player',
  'EDITOR_INSERTPIC' => 'Bild einfügen',
  'EDITOR_INSERTPIC_ASLINK' => 'Bild als Link einfügen',
  'EDITOR_INSERTSMILEY' => 'Smiley einfügen',
  'EDITOR_INSERTSYMBOL' => 'Symbol einfügen',
  'EDITOR_INSERTSYMBOL_ARROWS' => 'Pfeile',
  'EDITOR_INSERTSYMBOL_CHARS' => 'Zeichen',
  'EDITOR_INSERTSYMBOL_MATH' => 'Mathematische Zeichen',
  'EDITOR_INSERTSYMBOL_MISC' => 'Sonstige',
  'EDITOR_INSERTTABLE' => 'Tabelle einfügen',
  'EDITOR_INSERTTABLE_COLS' => 'Anzahl Spalten',
  'EDITOR_INSERTTABLE_ROWS' => 'Anzahl Zeilen',
  'EDITOR_LINKREL' => 'Beziehung',
  'EDITOR_LINKTARGET' => 'Ziel',
  'EDITOR_LINKTXT' => 'Text',
  'EDITOR_LINKURL' => 'URL',
  'EDITOR_PARAGRAPH' => 'Absatz',
  'EDITOR_PARAGRAPH_HEADLINE' => 'Überschrift {{num}}',
  'EDITOR_PINNED' => 'Artikel pinnen',
  'EDITOR_PINNED_DATE' => 'Artikel pinnen bis',
  'EDITOR_POSTPONED_DATE' => 'Fälligkeitsdatum',
  'EDITOR_POSTPONED_DATETIME' => 'Uhrzeit',
  'EDITOR_POSTPONETO' => 'Artikel freischalten',
  'EDITOR_PRE' => 'Vorformatierter Text',
  'EDITOR_REVISION_DATE' => 'Revisionsdatum',
  'EDITOR_REVISION_DELETE' => 'Revisionen löschen',
  'EDITOR_REVISION_RESTORE' => 'Revision wiederherstellen',
  'EDITOR_SELECTFS' => 'Schriftgröße',
  'EDITOR_SELECTSTYLES' => 'Styles',
  'EDITOR_SHARE' => 'Diesen Artikel teilen via',
  'EDITOR_SHARES' => 'Geteilte Inhalte und Likes',
  'EDITOR_SHARES_EMAIL' => 'Geteilt via E-Mail',
  'EDITOR_SHARES_FACEBOOK' => 'Geteilt via Facebook',
  'EDITOR_SHARES_LAST' => 'Zuletzt geteilt am',
  'EDITOR_SHARES_LIKEBUTTON' => 'Gefällt mir',
  'EDITOR_SHARES_PINTEREST' => 'Geteilt via Pinterest',
  'EDITOR_SHARES_REDDIT' => 'Geteilt via Reddit',
  'EDITOR_SHARES_TUMBLR' => 'Geteilt via Tumblr',
  'EDITOR_SHARES_TWITTER' => 'Geteilt via Twitter',
  'EDITOR_SHARES_WHATSAPP' => 'Geteilt via WhatsApp',
  'EDITOR_STATUS_APPROVAL' => 'Artikel muss freigegeben werden',
  'EDITOR_STATUS_ARCHIVE' => 'Artikel ist archiviert',
  'EDITOR_STATUS_COMMENTS' => 'Kommentare sind aktiv',
  'EDITOR_STATUS_DRAFT' => 'Artikel als Entwurf gespeichert',
  'EDITOR_STATUS_INEDIT' => 'Dieser Artikel befindet sich momentan in Bearbeitung durch {{username}}.',
  'EDITOR_STATUS_NOTINEDIT' => 'Dieser Artikel ist nicht mehr in Bearbeitung.',
  'EDITOR_STATUS_PINNED' => 'Artikel ist gepinnt',
  'EDITOR_STATUS_POSTPONETO' => 'Artikel wird freigeschaltet',
  'EDITOR_STATUS_REVISION' => 'Revision anzeigen (Revision = links, Aktuell = rechts)',
  'EDITOR_STATUS_REVISION_SHOW' => 'Revision öffnen',
  'EDITOR_TINYMCE_PLUGIN_OVERRIDE' => 'FPCM_TINYMCE_PLUGINS ist definiert, Änderungen an Plugins werden evtl. nicht übernommen.',
  'EDITOR_TWEET_ENABLED' => 'Tweet erzeugen',
  'EDITOR_TWEET_TEXT' => 'Twitter-Beitrag-Text',
  'EDITOR_TWEET_TEXT_REPLACER' => 'Platzhalter aus Tweet-Template nutzbar!',
  'ERROR_IP_LOCKED' => 'Deine IP-Adresse wurde für diese Aktion gesperrt! Um den Grund zu erfahren, wende dich an die Betreiber der Seite.',
  'FAILED_FILES_NEWTHUMBS' => 'Thumbnails konnten nicht erzeugt werden!<br>{{filenames}}',
  'FILE_FORM_FILEADD' => 'Datei(en) auswählen',
  'FILE_FORM_UPLOADCANCEL' => 'Upload abbrechen',
  'FILE_FORM_UPLOADSTART' => 'Upload starten',
  'FILE_LIST_ADDTOINDEX' => 'Dateien indizieren...',
  'FILE_LIST_ALTTEXT' => 'Alternativtext angeben',
  'FILE_LIST_EDIT' => 'Bild bearbeiten',
  'FILE_LIST_EDIT_CROP' => 'Zuschneiden',
  'FILE_LIST_EDIT_MOVE' => 'Verschieben',
  'FILE_LIST_EDIT_RESIZE' => 'Größe ändern',
  'FILE_LIST_EDIT_RESIZE_NOTICE' => 'Die Breite/ Höhe wird beim Speichern anhand des Seitenverhältnisses nachträglich auf den jeweils geänderten Wert angepasst.',
  'FILE_LIST_EDIT_ROTATE_ANTICLOCKWISE' => 'Gegen Uhrzeigersinn drehen',
  'FILE_LIST_EDIT_ROTATE_CLOCKWISE' => 'Im Uhrzeigersinn drehen',
  'FILE_LIST_EDIT_ZOOMIN' => 'Reinzoomen',
  'FILE_LIST_EDIT_ZOOMOUT' => 'Rauszoomen',
  'FILE_LIST_FILECREDITS' => 'Credits',
  'FILE_LIST_FILEHASH' => 'Dateihash',
  'FILE_LIST_FILENAME' => 'Dateiname',
  'FILE_LIST_FILESIZE' => 'Dateigröße',
  'FILE_LIST_FILETYPE' => 'MIME-Typ',
  'FILE_LIST_INSERTGALLERY' => 'Gallery einfügen',
  'FILE_LIST_INSERT_FULL' => 'Bild-URL einfügen',
  'FILE_LIST_INSERT_THUMB' => 'Thumbnail-URL einfügen',
  'FILE_LIST_NEWTHUMBS' => 'Thumbnails erzeugen',
  'FILE_LIST_OPEN_FULL' => 'Bild öffnen',
  'FILE_LIST_OPEN_THUMB' => 'Thumbnail öffnen',
  'FILE_LIST_PHPMAXINFO' => 'Maximal {{filecount}} Dateien mit {{filesize}}.',
  'FILE_LIST_RENAME' => 'Umbenennen',
  'FILE_LIST_RENAME_NEWNAME' => 'Bitte gibt einen neuen Dateiname ein:',
  'FILE_LIST_RESOLUTION' => 'Auflösung',
  'FILE_LIST_RESOLUTION_PIXEL' => 'Pixel',
  'FILE_LIST_SEARCHTEXT' => 'Dateiname oder alternativer Text',
  'FILE_LIST_SMILEYADD' => 'Smiley hinzufügen',
  'FILE_LIST_SMILEYCODE' => 'Smiley-Code',
  'FILE_LIST_SMILEYEDIT' => 'Smiley bearbeiten',
  'FILE_LIST_THUMB_SIZE' => 'Thumbnail-Größe',
  'FILE_LIST_UPLOADDROP' => 'Dateien zum Hochladen hier ablegen',
  'FILE_LIST_UPLOADFORM' => 'Dateien hochladen',
  'FILE_LIST_UPLOADSELECTED' => 'Zum Hochladen ausgewählte Dateien',
  'FILE_LIST_UPLOAD_BY' => 'Hochgeladen von',
  'FILE_LIST_UPLOAD_NOTFOUND' => 'Die zugehörige Datei wurde im Upload-Ordner nicht gefunden!',
  'FILE_NOT_WRITABLE' => 'Die ausgewählte Datei ist nicht beschreibbar, bitte prüfe die Berechtigungen auf dem Server.',
  'GLOBAL_ACTIONS' => 'Aktionen',
  'GLOBAL_ACTION_PERFORM' => 'Auszuführende Aktion',
  'GLOBAL_ADMINISTRATOR' => 'Administrator',
  'GLOBAL_AUTHOR' => 'Autor',
  'GLOBAL_AUTHOR_EDITOR' => 'Geschrieben von',
  'GLOBAL_BACK' => 'Zurück',
  'GLOBAL_CACHE_CLEAR' => 'Cache leeren',
  'GLOBAL_CLOSE' => 'Schließen',
  'GLOBAL_CONFIRM' => 'Bitte bestätigen',
  'GLOBAL_COPY' => 'Kopieren',
  'GLOBAL_COPY_OF' => 'Kopie von "%s"',
  'GLOBAL_COPY_OF_FILE' => 'Kopie_von_%s',
  'GLOBAL_DELETE' => 'Löschen',
  'GLOBAL_DEPRECATED' => 'Veraltet, wird in Kürze entfernt',
  'GLOBAL_DISABLE' => 'Deaktivieren',
  'GLOBAL_DOWNLOAD' => 'Herunterladen',
  'GLOBAL_EDIT' => 'Bearbeiten',
  'GLOBAL_EDITOR' => 'Redakteur',
  'GLOBAL_EDIT_SELECTED' => 'Ausgewählte Bearbeiten',
  'GLOBAL_EMAIL' => 'E-Mail-Adresse',
  'GLOBAL_ENABLE' => 'Aktivieren',
  'GLOBAL_EXTENDED' => 'Erweitert',
  'GLOBAL_EXTERNAL' => 'Extern',
  'GLOBAL_FRONTEND_OPEN' => 'Artikel auf Webseite anzeigen',
  'GLOBAL_HIDE' => 'Ausblenden',
  'GLOBAL_HTMLTAGS_ALLOWED' => 'Erlaubte HTML-Tags',
  'GLOBAL_INFO' => 'Informationen',
  'GLOBAL_INSERT' => 'Einfügen',
  'GLOBAL_LASTCHANGE' => 'Zuletzt geändert',
  'GLOBAL_METADATA' => 'Metainformationen',
  'GLOBAL_NEW' => 'Neu',
  'GLOBAL_NEXT' => 'Weiter',
  'GLOBAL_NO' => 'Nein',
  'GLOBAL_NOCHANGE' => 'Keine Änderungen durchgeführt',
  'GLOBAL_NOCHANGE_APPLY' => 'Keine Änderungen',
  'GLOBAL_NOTFOUND' => 'Nicht gefunden',
  'GLOBAL_NOTFOUND2' => 'Keine Einträge gefunden...',
  'GLOBAL_NOTFOUND_FILE' => 'Datei wurde nicht gefunden!',
  'GLOBAL_NOT_WRITABLE' => 'nicht beschreibbar',
  'GLOBAL_OK' => 'OK',
  'GLOBAL_OPENNEWWIN' => 'In neuem Fenster öffnen',
  'GLOBAL_OPTIONAL' => 'optional',
  'GLOBAL_PAGER' => 'Seite {{current}} von {{total}}',
  'GLOBAL_PASSWORD' => 'Passwort',
  'GLOBAL_PASSWORD_CONFIRM' => 'Aktuelles Passwort zur Bestätigung eingeben',
  'GLOBAL_PLEASEWAIT' => 'Einen Moment bitte...',
  'GLOBAL_PREVIEW' => 'Vorschau anzeigen',
  'GLOBAL_PROPERTIES' => 'Eigenschaften',
  'GLOBAL_RELOAD' => 'Aktualisieren',
  'GLOBAL_RESET' => 'Zurücksetzen',
  'GLOBAL_SAVE' => 'Speichern',
  'GLOBAL_SCROLLTOP' => 'Nach oben scrollen',
  'GLOBAL_SELECT' => 'Bitte auswählen',
  'GLOBAL_SELECTALL' => 'Alle auswählen',
  'GLOBAL_SHOW' => 'Einblenden',
  'GLOBAL_SUBMIT' => 'Absenden',
  'GLOBAL_USERNAME' => 'Benutzername',
  'GLOBAL_USER_ON_TIME' => '{{username}} am {{time}}',
  'GLOBAL_WRITABLE' => 'beschreibbar',
  'GLOBAL_WRITEMAIL' => 'E-Mail verfassen',
  'GLOBAL_YES' => 'Ja',
  'HEADLINE' => 'FanPress CM News System',
  'HELP_BTN_OPEN' => 'Hilfe-Eintrag aufrufen',
  'HL_ARCHIVE' => 'Archiv',
  'HL_ARTICLES' => 'Artikel',
  'HL_ARTICLE_ADD' => 'Artikel schreiben',
  'HL_ARTICLE_EDIT' => 'Artikel verwalten',
  'HL_ARTICLE_EDIT_ACTIVE' => 'Aktive Artikel',
  'HL_ARTICLE_EDIT_ALL' => 'Alle anzeigen',
  'HL_ARTICLE_EDIT_ARCHIVE' => 'Archivierte Artikel',
  'HL_ARTICLE_EDIT_COMMENTS' => '{{count}} Kommentar(e)',
  'HL_ARTICLE_EDIT_REVISIONS' => '{{count}} Revision(en)',
  'HL_BACKUPS' => 'Backupmanager',
  'HL_CATEGORIES_MNG' => 'Kategorien',
  'HL_COMMENTS_MNG' => 'Kommentare verwalten',
  'HL_CRONJOBS' => 'Cronjobs',
  'HL_DASHBOARD' => 'Dashboard',
  'HL_FILES_MNG' => 'Dateimanager',
  'HL_FRONTEND' => 'Frontend',
  'HL_HELP' => 'Hilfe',
  'HL_HELP_BACKDROP' => 'Hintergrundbild von',
  'HL_HELP_CACHE' => 'Cache',
  'HL_HELP_LICENCE' => 'Lizenzinformationen',
  'HL_HELP_SUPPORT' => 'Kontakt & Support',
  'HL_LOGS' => 'Protokolle',
  'HL_LOGS_CRONJOBS' => 'Cronjobs',
  'HL_LOGS_DATABASE' => 'Datenbank',
  'HL_LOGS_ERROR' => 'Ereignisse',
  'HL_LOGS_EVENTS' => 'Events',
  'HL_LOGS_PACKAGES' => 'Paketmanager',
  'HL_LOGS_SESSIONS' => 'Sessions',
  'HL_LOGS_SYSTEM' => 'Sonstige',
  'HL_MODULES' => 'Module',
  'HL_OPTIONS' => 'Optionen',
  'HL_OPTIONS_IPBLOCKING' => 'IP-Adressen',
  'HL_OPTIONS_PERMISSIONS' => 'Berechtigungen',
  'HL_OPTIONS_SMILEYS' => 'Smileys',
  'HL_OPTIONS_SYSTEM' => 'Systemeinstellungen',
  'HL_OPTIONS_TEMPLATES' => 'Templates',
  'HL_OPTIONS_USERS' => 'Benutzer & Rollen',
  'HL_OPTIONS_WORDBAN' => 'Textzensur/ Autokorrektur',
  'HL_PACKAGEMGR_SYSUPDATES' => 'FanPress CM aktualisieren',
  'HL_PROFILE' => 'Profil',
  'HL_TEMPLATE_PREVIEW' => 'Template-Vorschau',
  'HL_UTILITIES' => 'Werkzeuge',
  'IMPORT_DELIMITER' => 'Trennzeichen',
  'IMPORT_ENCLOSURE' => 'Begrenzungszeichen',
  'IMPORT_EXCLUDE_FIRST' => 'Erste Zeile überspringen',
  'IMPORT_FIELDS' => 'Feldzuweisung',
  'IMPORT_FIELDS_CSV' => 'Reihenfolge in CSV-Datei',
  'IMPORT_FIELDS_OBJECT' => 'Verfügbare Felder',
  'IMPORT_FILE' => 'CSV-Datei',
  'IMPORT_ITEM' => 'Importieren nach',
  'IMPORT_MAIN' => 'CSV-Import',
  'IMPORT_MSG_CSVINVALID' => 'Die übermittelte Datei ist keine gültige CSV-Datei!',
  'IMPORT_MSG_CSVNOTFOUND' => 'Die hochgeladene CSV-Datei wurde nicht gefunden. Führe einen Upload durch, setze den Import ggf. vorher zurück.',
  'IMPORT_MSG_EMPTYFIELD' => 'Die ausgewählten Felder dürfen nicht leer sein.',
  'IMPORT_MSG_FAILEDSAVE' => 'Beim Speichern der zu importierenden Dateien ist ein Fehler aufgetreten. Für Details prüfen die Systemprotokolle.',
  'IMPORT_MSG_FINISHED' => 'Der CSV-Import wurde abgeschlossen.',
  'IMPORT_MSG_INITFAILED' => 'Fehler beim Initialisieren des Imports, keine Importkennung vorhanden!',
  'IMPORT_MSG_INVALIDIMPORTTYPE' => 'Das ausgewählte Import-Ziel ist ungültig: {{importtype}}',
  'IMPORT_MSG_INVALIDIMPORTTYPE_NONE' => 'Bitte wähle ein Importziel aus und die zu importierenden Felder aus.',
  'IMPORT_MSG_NOFIELDS' => 'Keine Feldzuweisung getroffen. Wähle die zu füllenden Felder aus und sortiere diese gemäß der Reihenfolge in der CSV-Datei.',
  'IMPORT_MSG_NOFILE' => 'Es wurde keine Datei zum Import hochgeladen.',
  'IMPORT_MSG_NOHANDLE' => 'Die zu importierende CSV-Datei konnte nicht geöffnet werden.',
  'IMPORT_NOTICE_UTF8' => 'Die zu importierenden Daten müssen im UTF-8-Zeichensatz vorliegen, andernfalls kann es zu defekten Umlauten und sonstigen Sonderzeichen kommen!',
  'IMPORT_OPTIONS' => 'Import-Einstellungen',
  'IMPORT_PROGRESS' => 'Importiere {{filename}}',
  'IMPORT_START' => 'Import starten',
  'INSTALLER' => 'Installations-Assistent',
  'INSTALLER_ADMINUSER' => 'Administrator-Account',
  'INSTALLER_CREATETABLES' => 'Datenbank-Tabellen',
  'INSTALLER_CREATETABLES_ERROR' => 'Fehler beim Verarbeiten der Datenbank-Struktur',
  'INSTALLER_CREATETABLES_HEAD' => 'erzeuge Datenbank-Tabellen, bitte warten...',
  'INSTALLER_CREATETABLES_STEP' => 'erzeuge Tabelle <em>{{tablename}}</em>...',
  'INSTALLER_DBCONNECTION' => 'Datenbank-Verbindung',
  'INSTALLER_DBCONNECTION_FAILEDMSG' => 'Mit den eingegebenen Daten konnte keine Verbindung zur Datenbank hergestellt werden!',
  'INSTALLER_DBCONNECTION_HOST' => 'Host (meist localhost)',
  'INSTALLER_DBCONNECTION_NAME' => 'Datenbank-Name',
  'INSTALLER_DBCONNECTION_PASS' => 'Passwort',
  'INSTALLER_DBCONNECTION_PREF' => 'Tabellen-Präfix',
  'INSTALLER_DBCONNECTION_TYPE' => 'Typ',
  'INSTALLER_DBCONNECTION_USER' => 'Benutzer',
  'INSTALLER_FINALIZE' => 'Installation beenden',
  'INSTALLER_FINALIZE_DIABLED' => '<strong>Wichtig:</strong> Lösche via FTP unbedingt die Datei <strong>/data/config/installer.enabled</strong> um den Installationsassistenten zu deaktivieren, sollte die Datei noch existieren!',
  'INSTALLER_FINALIZE_TEXT' => '<strong>Herzlichen Glückwunsch!</strong> Die Installation von FanPress CM wurde erfolgreich abgeschlossen! Du kannst dich nun in deinem System anmelden! {{icon="smile-o"}}',
  'INSTALLER_LANGUAGE_SELECT' => 'Sprache auswählen',
  'INSTALLER_SYSCHECK' => 'Systemvoraussetzungen',
  'INSTALLER_SYSCHECK_FAILEDMSG' => 'FanPress CM kann nicht installiert werden, da die Systemvoraussetzungen nicht erfüllt werden!',
  'INSTALLER_SYSTEMCONFIG' => 'Systemeinstellungen',
  'IPLIST_ADDIP' => 'IP-Adresse sperren',
  'IPLIST_BLOCKTYPE' => 'Art der Sperre',
  'IPLIST_IPADDRESS' => 'IP-Adresse',
  'IPLIST_IPTIME' => 'gesperrt am',
  'IPLIST_NOACCESS' => 'Kein Frontend-Zugriff',
  'IPLIST_NOCOMMENTS' => 'Keine Kommentare schreiben',
  'IPLIST_NOLOGIN' => 'Kein ACP-Login',
  'LABEL_FIELD_ARTICLE_RELATESTO' => 'Artikel bezieht sich auf',
  'LABEL_FIELD_FILE_CROPPER_NAME' => 'Dateiname-Muster bearbeiteter Bilder',
  'LABEL_FIELD_FILE_CROPPER_NAME_HELP' => '{{filename}}: Dateiname, {{date}}: aktuelles Datum, {{datelong}}: aktuelles Datum mit Zeit, {{hash}}: Dateihash, {{userid}}:  Benutzer-ID, {{random}}: Zufallszahl',
  'LABEL_FIELD_OPENQR' => 'QR-Code anzeigen',
  'LABEL_SEARCH_GLOBAL' => 'Gibt mindestens drei Zeichen ein.',
  'LABEL_SEARCH_GLOBAL_RESULTSIZE' => 'Es werden nicht alle {{result_count}} Suchergebnisse angezeigt.',
  'LOAD_FAILED_ARTICLE' => 'Der gesuchte Artikel wurde nicht gefunden.',
  'LOAD_FAILED_ARTICLE_LIST' => 'Die gesuchte Seite wurde nicht gefunden.',
  'LOAD_FAILED_CATEGORY' => 'Die gesuchte Kategorie wurde nicht gefunden.',
  'LOAD_FAILED_COMMENT' => 'Der gesuchte Kommentar wurde nicht gefunden.',
  'LOAD_FAILED_COMMENT_ARTICLE' => 'Der zu diesem Kommentar gehörige Artikel wurde nicht gefunden. Der Kommentar muss zu einem anderen Artikel verschoben werden, um im Frontend sichtbar zu sein.',
  'LOAD_FAILED_ROLL' => 'Die gesuchte Benutzerrolle wurde nicht gefunden.',
  'LOAD_FAILED_USER' => 'Der gesuchte Benutzer wurde nicht gefunden.',
  'LOAD_FAILED_WORDBAN' => 'Der Begriff wurde nicht gefunden.',
  'LOGIN_ATTEMPTS_MAX' => 'Du hast deinen Benutzernamen oder Passwort {{logincount}}-mal falsch eingeben. Der Zugang wurde um {{lockeddate}} für {{lockedtime}} Minuten gesperrt.',
  'LOGIN_AUTHCODE' => 'Sechsstelligen Authenticator-Code eingeben',
  'LOGIN_BTN' => 'Anmelden',
  'LOGIN_FAILED' => 'Der Benutzername oder das Passwort sind falsch. Bitte versuche es erneut.',
  'LOGIN_FAILED_CODE' => 'Der eingegebene Authenticator-Code war falsch. Bitte versuche es erneut.',
  'LOGIN_FAILED_DISABLED' => 'Der angegebene Benutzername wurde deaktiviert.',
  'LOGIN_NEWPASSWORD' => 'Neues Passwort anfordern',
  'LOGIN_PASSWORD_RESET' => 'Dein Passwort wurde erfolgreich zurückgesetzt! Prüfe deinen Posteingang auf die E-Mail mit dem neuen Passwort.',
  'LOGIN_PASSWORD_RESET_FAILED' => 'Beim Anfordern des neuen Passworts ist ein Fehler aufgetreten!',
  'LOGIN_REQUIRED' => 'Bitte melde dich an, um die angeforderte Seite aufrufen zu können!',
  'LOGOUT_BTN' => 'Abmelden',
  'LOGS_CLEARED_LOG_FAILED' => 'Das ausgewählte Protokoll konnte nicht geleert werden!',
  'LOGS_CLEARED_LOG_OK' => 'Das ausgewählte Protokoll wurde geleert.',
  'LOGS_CLEARLOG' => 'Leeren',
  'LOGS_LIST_IPADDRESS' => 'IP-Adresse',
  'LOGS_LIST_LOGIN' => 'Login am',
  'LOGS_LIST_LOGOUT' => 'Logout am',
  'LOGS_LIST_PERIOD' => 'Loginzeitraum',
  'LOGS_LIST_SESSIONID' => 'Kennung',
  'LOGS_LIST_TEXT' => 'Protokolldaten',
  'LOGS_LIST_TIME' => 'Zeit',
  'LOGS_LIST_USER' => 'Benutzer',
  'LOGS_LIST_USERAGENT' => 'User-Agent',
  'MAINTENANCE_MODE_ENABLED' => 'Der Wartungsmodus von FanPress CM ist gerade aktiv, daher steht diese Funktion im Moment nicht zur Verfügung.',
  'MODULES_FAILED_DEPENCIES' => 'Es wurden nicht-erfüllte Abhängigkeiten erkannt, dass Modul kann daher nicht installiert werden!',
  'MODULES_FAILED_DISABLE' => 'Das ausgewählte Modul konnten nicht deaktiviert werden.',
  'MODULES_FAILED_ENABLE' => 'Das ausgewählte Modul konnten nicht aktiviert werden.',
  'MODULES_FAILED_FSWRITE' => 'Das Dateisystem ist für das Modul bzw. seine Dateien nicht beschreibbar!',
  'MODULES_FAILED_INSTALL' => 'Das ausgewählte Modul konnte nicht installiert werden.',
  'MODULES_FAILED_UNINSTALL' => 'Das ausgewählte Modul konnte nicht deinstalliert werden.',
  'MODULES_KEY_INVALID' => 'Der Modul-Schlüssel ist ungültig, Details findest du im Ereignis-Protokoll.',
  'MODULES_LIST_AUTHOR' => 'Autor',
  'MODULES_LIST_AVAILABLE' => 'Verfügbare Module',
  'MODULES_LIST_BACKTOLIST' => 'zurück zur Modul-Liste',
  'MODULES_LIST_CONFIGURE' => 'Modul konfigurieren',
  'MODULES_LIST_DATAPATH' => 'Pfad im /data-Ordner',
  'MODULES_LIST_DELETE' => 'Modul löschen',
  'MODULES_LIST_DESCRIPTION' => 'Beschreibung',
  'MODULES_LIST_DISABLE' => 'Modul deaktivieren',
  'MODULES_LIST_DOWNLOAD' => 'Modul-Paketdatei herunterladen',
  'MODULES_LIST_ENABLE' => 'Modul aktivieren',
  'MODULES_LIST_HEADLINE' => 'Installierte Module',
  'MODULES_LIST_INFORMATIONS' => 'Modul-Detail-Informationen',
  'MODULES_LIST_INSTALL' => 'Modul installieren',
  'MODULES_LIST_INSTALLING' => 'Installiere Modul {{modulekey}}',
  'MODULES_LIST_KEY' => 'Schlüssel',
  'MODULES_LIST_LICENCE' => 'Lizenz',
  'MODULES_LIST_LINK' => 'Info-Link',
  'MODULES_LIST_NAME' => 'Name',
  'MODULES_LIST_REQUIRE_FPCM' => 'Erfordert FanPress CM',
  'MODULES_LIST_REQUIRE_PHP' => 'Erfordert PHP',
  'MODULES_LIST_SUPPORT' => 'Support & Kontakt',
  'MODULES_LIST_UNINSTALL' => 'Modul deinstallieren',
  'MODULES_LIST_UPDATE' => 'Modul aktualisieren',
  'MODULES_LIST_UPDATE_ALL' => 'Updates für alle Module einspielen',
  'MODULES_LIST_UPDATE_NEXT' => 'Zum nächsten Modul-Update...',
  'MODULES_LIST_UPDATING' => 'Aktualisiere Modul {{modulekey}}',
  'MODULES_LIST_UPLOAD' => 'Modul-Paketdatei hochladen',
  'MODULES_LIST_VERSION_LOCAL' => 'Version (lokal)',
  'MODULES_LIST_VERSION_REMOTE' => 'Version (Server)',
  'MSG_FILES_CREATETHUMBS' => 'Vorschaubilder werden neu erzeugt...',
  'NAVIGATION_SHOW' => 'Menü',
  'NOTIFICATION_ERROR_EVENTS' => 'Beim Ausführen des Events "{{eventName}}" ist ein Fehler aufgetreten. Prüfe die Systemprokolle und aktualisiere installierte Module.',
  'NOTIFICATION_EXPERIMENTAL_MINJS' => 'Minimierte JavaScript-Dateien werden verwendet. Änderungen werden evtl. nicht sofort übernommen.',
  'PACKAGEMANAGER_BACKUPFS' => 'Erstelle Dateisystem-Backup...',
  'PACKAGEMANAGER_CHECKLOCAL' => 'Überprüfe Dateisystem...',
  'PACKAGEMANAGER_CHECKPKG' => 'Überprüfe Paketinformationen <em>{{var}}</em>',
  'PACKAGEMANAGER_CLEANUP' => 'Aufräumen des Systems...',
  'PACKAGEMANAGER_CURRENTLANGUAGE' => 'Aktuelle Sprache',
  'PACKAGEMANAGER_CURRENTVERSION' => 'Aktuelle Version',
  'PACKAGEMANAGER_DOWNLOAD' => 'Herunterladen des Pakets <em>{{var}} {{var2}}</em>',
  'PACKAGEMANAGER_EXTRACT' => 'Entpacke Paket <em>{{var}}</em>',
  'PACKAGEMANAGER_FAILED' => 'Bei der Installation des Pakets ist ein Fehler aufgetreten. Ausführliche Informationen beinhaltet das Fehler-Protokoll.',
  'PACKAGEMANAGER_FAILED_UPDATE' => 'Bei der Aktualisierung des Pakets ist ein Fehler aufgetreten. Ausführliche Informationen beinhaltet das Fehler-Protokoll.',
  'PACKAGEMANAGER_MAINTENANCE_DIS' => 'Deaktiviere Wartungsmodus...',
  'PACKAGEMANAGER_MAINTENANCE_EN' => 'Aktiviere Wartungsmodus...',
  'PACKAGEMANAGER_NEWVERSION' => 'Neue Version:',
  'PACKAGEMANAGER_SUCCESS' => 'Die Installation des Pakets wurde erfolgreich durchgeführt.',
  'PACKAGEMANAGER_SUCCESS_UPDATE' => 'Die Aktualisierung des Pakets wurde erfolgreich durchgeführt.',
  'PACKAGEMANAGER_TIMER' => 'Benötigte Zeit:',
  'PACKAGEMANAGER_UPDATEDB' => 'Aktualisierung wird abgeschlossen...',
  'PACKAGEMANAGER_UPDATEFS' => 'Aktualisiere Dateisystem...',
  'PACKAGEMANAGER_UPDATELOG' => 'Aktualisiere Paketmanager-Protokoll...',
  'PACKAGES_BACKTODASHBOARD' => 'Zurück zum Dashboard',
  'PACKAGES_FAILED_DOWNLOAD_UNTRUSTED' => 'Die verfügbare Paketdatei wird nicht heruntergeladen, da dem Paket-Server <em>{{var}}</em> nicht vertraut wird.',
  'PACKAGES_FAILED_ERROR901' => 'Es konnte keine Verbindung zum Paket-Server hergestellt werden!',
  'PACKAGES_FAILED_ERROR902' => 'Es konnte keine lokale Paketdatei erzeugt werden!',
  'PACKAGES_FAILED_ERROR903' => 'Beim Schreiben der lokalen Paketdatei ist ein Fehler aufgetreten!',
  'PACKAGES_FAILED_ERROR904' => 'Die lokale Paketdatei wurde nicht gefunden!',
  'PACKAGES_FAILED_ERROR906' => 'Die Archiv-Datei konnte nicht geöffnet werden!',
  'PACKAGES_FAILED_ERROR907' => 'Beim Entpacken der Archiv-Datei ist ein Fehler aufgetreten!',
  'PACKAGES_FAILED_ERROR908' => 'Beim Aktualisieren der lokalen Dateien ist ein Fehler aufgetreten! Weitere Informationen enthält das Paketmanager-Protokoll.',
  'PACKAGES_FAILED_ERROR_BACKUPS' => 'Beim Erzeugen des Dateisystem-Backups ist ein Fehler aufgetreten! Bitte prüfe das Ereignisprotokoll für detaillierte Informationen.',
  'PACKAGES_MANUALCHECK' => 'Auf Aktualisierung prüfen',
  'PACKAGES_UPDATE' => 'Aktualisierung starten',
  'PACKAGES_UPDATES_LIST' => 'Aktualisierungen anzeigen',
  'PASSWORD_NEWPASSWORDSET_SUBJECT' => 'Neues Passwort festgelegt',
  'PASSWORD_NEWPASSWORDSET_TEXT' => 'Für deinen FanPress CM-Account <b>{{username}}</b> wurde das Passwort <b>{{newpass}}</b> festgelegt. Mit diesen Daten kannst du dich anmelden und auch ein eigenes Passwort vergeben.',
  'PASSWORD_RESET_SUBJECT' => 'Neues Passwort angefordert',
  'PASSWORD_RESET_TEXT' => 'Für dich wurde ein neues Passwort angefordert. Dies lautet <b>{{newpass}}</b>. Hast du dies nicht selbst veranlasst, so kontaktiere schnellstmöglich einen Administrator.',
  'PASSWORD_TOGGLE' => 'Passwort anzeigen',
  'PERMISSIONS_REQUIRED' => 'Du hast keine Berechtigungen um auf diese Seite zuzugreifen!',
  'PERMISSION_ARTICLES' => 'Artikel',
  'PERMISSION_ARTICLE_ADD' => 'Artikel schreiben',
  'PERMISSION_ARTICLE_APPROVE' => 'Artikel müssen freigeschaltet werden',
  'PERMISSION_ARTICLE_ARCHIVE' => 'Artikel archivieren und im Archiv bearbeiten',
  'PERMISSION_ARTICLE_AUTHORS' => 'Artikel-Autor ändern',
  'PERMISSION_ARTICLE_DELETE' => 'Artikel löschen',
  'PERMISSION_ARTICLE_EDIT' => 'Eigene Artikel Bearbeiten',
  'PERMISSION_ARTICLE_EDITALL' => 'Aktive Artikel Bearbeiten',
  'PERMISSION_ARTICLE_MASSEDIT' => 'Artikel in Masse bearbeiten',
  'PERMISSION_ARTICLE_REVISIONS' => 'Revisionen verwalten',
  'PERMISSION_COMMENTS' => 'Kommentare',
  'PERMISSION_COMMENT_APPROVE' => 'Kommentare genehmigen',
  'PERMISSION_COMMENT_DELETE' => 'Kommentare löschen',
  'PERMISSION_COMMENT_EDIT' => 'Kommentare auf eigene Artikel bearbeiten',
  'PERMISSION_COMMENT_EDITALL' => 'Kommentare auf alle Artikel bearbeiten',
  'PERMISSION_COMMENT_LOCKIP' => 'IP-Adresse des Kommentars sperren',
  'PERMISSION_COMMENT_MASSEDIT' => 'Kommentare in Masse bearbeiten',
  'PERMISSION_COMMENT_MOVE' => 'Kommentare zu anderem Artikel verschieben',
  'PERMISSION_COMMENT_PRIVATE' => 'Kommentare auf "Privat" setzen',
  'PERMISSION_MODULES' => 'Module',
  'PERMISSION_MODULES_CONFIGURE' => 'Module konfigurieren',
  'PERMISSION_MODULES_INSTALL' => 'Module installieren',
  'PERMISSION_MODULES_UNINSTALL' => 'Module deinstallieren',
  'PERMISSION_SYSTEM' => 'System',
  'PERMISSION_SYSTEM_BACKUPS' => 'Backups verwalten',
  'PERMISSION_SYSTEM_CATEGORIES' => 'Kategorien verwalten',
  'PERMISSION_SYSTEM_CRONS' => 'Cronjobs verwalten',
  'PERMISSION_SYSTEM_CSVIMPORT' => 'CSV-Import ausführen',
  'PERMISSION_SYSTEM_DRAFTS' => 'Artikel-Vorlagen verwalten',
  'PERMISSION_SYSTEM_IPADDR' => 'IP-Adressen verwalten',
  'PERMISSION_SYSTEM_LOGS' => 'System-Protokolle verwalten',
  'PERMISSION_SYSTEM_OPTIONS' => 'Systemeinstellungen verwalten',
  'PERMISSION_SYSTEM_PERMISSIONS' => 'Berechtigungen verwalten',
  'PERMISSION_SYSTEM_PROFILE' => 'Profil ändern',
  'PERMISSION_SYSTEM_ROLLS' => 'Rollen verwalten',
  'PERMISSION_SYSTEM_SMILEYS' => 'Smileys verwalten',
  'PERMISSION_SYSTEM_TEMPLATES' => 'Templates verwalten',
  'PERMISSION_SYSTEM_UPDATE' => 'Updates durchführen',
  'PERMISSION_SYSTEM_USERS' => 'Benutzer verwalten',
  'PERMISSION_SYSTEM_WORDBAN' => 'Textzensur/ Autokorrektur verwalten',
  'PERMISSION_UPLOADS' => 'Dateimanager',
  'PERMISSION_UPLOADS_ADD' => 'Dateien hochladen',
  'PERMISSION_UPLOADS_DELETE' => 'Dateien löschen',
  'PERMISSION_UPLOADS_RENAME' => 'Dateien umbenennen',
  'PERMISSION_UPLOADS_THUMBS' => 'Thumbnails erzeugen',
  'PERMISSION_UPLOADS_VISIBLE' => 'Dateimanager ist sichtbar',
  'PROFILE_MENU_LOGGEDINAS' => 'Hallo {{username}}.',
  'PROFILE_MENU_LOGGEDINSINCE' => 'Du bist angemeldet seit',
  'PROFILE_MENU_NOTIFICATIONS' => 'Benachrichtigungen',
  'PROFILE_MENU_OPENPROFILE' => 'Benutzerprofil',
  'PROFILE_MENU_YOURIP' => 'Deine IP-Adresse:',
  'PROFILE_OPEN' => 'Mein Profil öffnen',
  'PUBLIC_ARCHIVE_LIMIT' => 'Das Archiv zeigt nur Artikel an, welche nach dem <strong>{{archievDate}}</strong> veröffentlicht wurden.',
  'PUBLIC_ARTICLE_OLD' => 'Dieser Artikel ist bereits sehr alt. Die Informationen können falsch oder veraltet sein.',
  'PUBLIC_ARTICLE_PINNED' => 'Dieser Artikel ist gepinnt und wird über allen anderen angezeigt.',
  'PUBLIC_COMMENT_EMAIL_SUBJECT' => 'Es wurde ein neuer Kommentar geschrieben',
  'PUBLIC_COMMENT_EMAIL_TEXT' => 'Von {{name}} (E-Mail-Adresse: {{email}}) wurde ein Kommentar auf den Artikel {{articleurl}} geschrieben.

{{commenttext}}

Logge dich ein, um den Kommentar zu moderieren. {{systemurl}}',
  'PUBLIC_FAILED_CAPTCHA' => 'Du hast die Captcha-Frage nicht korrekt beantwortet!',
  'PUBLIC_FAILED_EMAIL' => 'Es wurde keine gültige E-Mail-Adresse eingegeben!',
  'PUBLIC_FAILED_FLOOD' => 'Bitte warte mindestens {{seconds}} Sekunden, bevor du einen weiteren Kommentar schreibst!',
  'PUBLIC_FAILED_NAME' => 'Bitte gibt deinen Namen ein!',
  'PUBLIC_PRIVACY' => 'Du musst unserer Datenschutz-Erklärung zustimmen, um einen Kommentar zu verfassen.',
  'PUBLIC_SHARE_LIKE' => 'Danke für den Like. Wir freuen uns, dass dir der Beitrag gefällt!',
  'RECENT_ARTICLES' => '{{icon="book"}} Zuletzt geschriebene News',
  'RECENT_COMMENTS' => '{{icon="comments"}} Zuletzt geschriebene Kommentare',
  'RECENT_FPCMNEWS' => '{{icon="rss"}} Aktuelle FanPress CM News',
  'RECENT_TWEETS' => '{{icon="twitter" prefix="fab"}} Letzte Tweets',
  'RECENT_TWEETS_LOAD_FAILURE' => 'Der Twitter-Verlauf konnte aufgrund von API-Level-Einschränkungen nicht geladen werden.',
  'RECENT_TWEETS_REWTEETS' => 'Retweets',
  'RENAME_FAILED_FILE' => 'Die Datei {{filename1}} konnte nicht in {{filename2}} umbenannt werden!',
  'RSSFEED_DISABLED' => 'Der RSS-Feed ist deaktiviert. Wende dich für weitere Informationen an den Seitenbetreiber.',
  'SAVE_FAILED_ARTICLE' => 'Der Artikel konnte nicht gespeichert werden!',
  'SAVE_FAILED_ARTICLEAPPROVAL' => 'Die Artikel-Freigaben konnten nicht geändert werden!',
  'SAVE_FAILED_ARTICLEARCHIVE' => 'Die Artikel konnten nicht archiviert werden!',
  'SAVE_FAILED_ARTICLECOMMENTS' => 'Die Kommentare konnten nicht für die Artikel (de)aktiviert werden!',
  'SAVE_FAILED_ARTICLENEWTWEET' => 'Für die Artikel konnten keine Tweets erzeugt werden!<br>{{titles}}',
  'SAVE_FAILED_ARTICLEPINN' => 'Die Artikel konnten nicht (ab)gepinnt werden!',
  'SAVE_FAILED_ARTICLERESTORE' => 'Die Elemente konnten nicht wiederhergestellt werden!',
  'SAVE_FAILED_ARTICLEREVRESTORE' => 'Die Revision konnte nicht wiederhergestellt werden!',
  'SAVE_FAILED_ARTICLES' => 'Die Änderungen an den Artikeln konnte nicht gespeichert werden!',
  'SAVE_FAILED_ARTICLETEMPLATE' => 'Die Artikel-Vorlage konnte nicht gespeichert werden!',
  'SAVE_FAILED_ARTICLE_EMPTY' => 'Du musst einen Titel und einen Text eingeben, bevor du den Artikel speichern kannst!',
  'SAVE_FAILED_CATEGORY' => 'Die Kategorie konnte nicht gespeichert werden!',
  'SAVE_FAILED_CATEGORY_EXISTS' => 'Der Kategorie-Name existiert bereits! Bitte wähle einen anderen Namen.',
  'SAVE_FAILED_COMMENT' => 'Der Kommentar konnte nicht gespeichert werden!',
  'SAVE_FAILED_COMMENTS' => 'Die Änderungen an den Kommentaren konnten nicht gespeichert werden!',
  'SAVE_FAILED_FILE_ALTTEXT' => 'Der Alternativ-Test konnte nicht gespeichert werden.',
  'SAVE_FAILED_IPADDRESS' => 'Die IP-Adresse konnte nicht gesperrt werden!',
  'SAVE_FAILED_IPADDRESS_SAME' => 'Deine eigene IP-Adresse kann nicht gesperrt werden!',
  'SAVE_FAILED_IPINVALID' => 'Die eingegebe IP-Adresse ist ungültig und kann daher nicht gesperrt werden!',
  'SAVE_FAILED_OPTIONS' => 'Die Änderungen an der Konfiguration konnten nicht gespeichert werden!',
  'SAVE_FAILED_OPTIONS_MODULES' => 'Die Änderungen an der Konfiguration konnten nicht gespeichert werden, da keine Daten im Feld "config" gefunden wurden.!',
  'SAVE_FAILED_OPTIONS_SMTP_CONECT' => 'Die SMTP-Verbindung war nicht erfolgreich!!',
  'SAVE_FAILED_OPTIONS_SMTP_HOST' => 'Für die SMTP-Server-Adresse wurde ein fehlerhafter Wert erkannt!',
  'SAVE_FAILED_PASSWORD_MATCH' => 'Die eingegebenen Passwörter stimmen nicht überein.',
  'SAVE_FAILED_PASSWORD_MATCH_CURRENT' => 'Das aktuelle Passwort stimmt nicht.',
  'SAVE_FAILED_PASSWORD_SECURITY' => 'Ein Password muss Groß- und Kleinbuchstaben sowie Zahlen enthalten und min. 6 Zeichen lang sein.',
  'SAVE_FAILED_PASSWORD_SECURITY_PWNDPASS' => 'Das eingegebene Passwort wird sehr häufig verwendet und ist daher potenziell gefährlich! Es sollte daher nicht verwendet werden.',
  'SAVE_FAILED_PERMISSIONS' => 'Die Änderungen an den Berechtigungen für die ausgewählte Rolle konnten nicht gespeichert werden!',
  'SAVE_FAILED_ROLL' => 'Die Benutzerrolle konnte nicht gespeichert werden!',
  'SAVE_FAILED_ROLL_EXISTS' => 'Eine Rolle mit dem eingegebenen Namen existiert bereits.',
  'SAVE_FAILED_SMILEY' => 'Der Smiley konnte nicht gespeichert werden!',
  'SAVE_FAILED_TEMPLATE' => 'Beim Speichern des Templates {{filename}} ist ein Fehler aufgetreten!',
  'SAVE_FAILED_TEMPLATE_CF_PRIVACYMISSING' => 'Das Kommentar-Formular-Template konnte nicht gespeichert werden. Der Platzhalter {{privacyComfirmation}} fehlt!',
  'SAVE_FAILED_TEMPLATE_CF_URLMISSING' => 'Das Kommentar-Formular-Template konnte nicht gespeichert werden. Der Platzhalter {{submitUrl}} fehlt!',
  'SAVE_FAILED_UPLOADAUTHORIMG' => 'Beim Hochladen des Avatars ist ein Fehler aufgetreten!',
  'SAVE_FAILED_UPLOADMODULE' => 'Beim Hochladen der Modul-Paketdatei ist ein Fehler aufgetreten!',
  'SAVE_FAILED_UPLOADPHP' => 'Beim Hochladen der Dateien ist ein Fehler aufgetreten!<br>{{filenames}}',
  'SAVE_FAILED_UPLOADTPLFILE' => 'Beim Hochladen der Vorlage ist ein Fehler aufgetreten!',
  'SAVE_FAILED_UPLOAD_COPY' => 'Beim Kopieren der Dateien ist ein Fehler aufgetreten!',
  'SAVE_FAILED_UPLOAD_GEN' => 'Beim Hochladen der Dateien ist folgender Fehler aufgetreten: <em>{{uploadMsg}}</em>',
  'SAVE_FAILED_USER' => 'Der Benutzer konnte nicht gespeichert werden!',
  'SAVE_FAILED_USER_DISABLE' => 'Der Benutzer konnte nicht deaktiviert werden!',
  'SAVE_FAILED_USER_DISABLE_LAST' => 'Der letzte Benutzer kann nicht deaktiviert werden!',
  'SAVE_FAILED_USER_DISABLE_OWN' => 'Du kannst deinen eigenen Account nicht deaktivieren!',
  'SAVE_FAILED_USER_EMAIL' => 'Für den Benutzer wurde keine gültige E-Mail-Adresse angegeben!',
  'SAVE_FAILED_USER_ENABLE' => 'Der Benutzer konnte nicht aktiviert werden!',
  'SAVE_FAILED_USER_EXISTS' => 'Ein Benutzer mit dem gewählten Benutzernamen existiert bereits!',
  'SAVE_FAILED_USER_PROFILE' => 'Die Änderung am Profil konnten nicht gespeichert werden!',
  'SAVE_FAILED_USER_PROFILEEMAIL' => 'Du musst eine gültige E-Mail-Adresse angegeben!',
  'SAVE_FAILED_USER_SECURITY' => 'Der eingegebene Benutzername ist potenziell gefährlich und kann daher nicht verwendet werden!',
  'SAVE_FAILED_WORDBAN' => 'Der Begriff konnte nicht gespeichert werden!',
  'SAVE_SUCCESS_ADDCATEGORY' => 'Die Kategorie wurde gespeichert!',
  'SAVE_SUCCESS_ADDROLL' => 'Die Benutzerrolle wurde gespeichert!',
  'SAVE_SUCCESS_ADDUSER' => 'Der Benutzer wurde gespeichert!',
  'SAVE_SUCCESS_ARTICLE' => 'Der Artikel wurde gespeichert!',
  'SAVE_SUCCESS_ARTICLENEWTWEET' => 'Für die Artikel wurden neue Tweets erzeugt!<br>{{titles}}',
  'SAVE_SUCCESS_ARTICLERESTORE' => 'Die Elemente wurden wiederhergestellt!',
  'SAVE_SUCCESS_ARTICLEREVRESTORE' => 'Die Revision wurde wiederhergestellt!',
  'SAVE_SUCCESS_ARTICLETEMPLATE' => 'Die Artikel-Vorlage wurde gespeichert!',
  'SAVE_SUCCESS_ARTICLE_APPROVAL' => 'Der Artikel wurde gespeichert, muss aber freigeschaltet werden!',
  'SAVE_SUCCESS_COMMENT' => 'Der Kommentar wurde gespeichert!',
  'SAVE_SUCCESS_EDITCATEGORY' => 'Die Änderungen an der Kategorie wurden gespeichert!',
  'SAVE_SUCCESS_EDITROLL' => 'Die Änderungen an der Benutzerrolle wurden gespeichert!',
  'SAVE_SUCCESS_EDITUSER' => 'Die Änderungen am Benutzer wurden gespeichert!',
  'SAVE_SUCCESS_EDITUSER_PROFILE' => 'Die Änderungen an deinem Profil wurden gespeichert!',
  'SAVE_SUCCESS_FILE_ALTTEXT' => 'Der Alternativtext wurde erfolgreich gespeichert.',
  'SAVE_SUCCESS_IPADDRESS' => 'Die IP-Adresse wurde gesperrt!',
  'SAVE_SUCCESS_IPADDRESS_CHG' => 'Die Änderungen an der IP-Adresse-Sperre wurden gespeichert!',
  'SAVE_SUCCESS_OPTIONS' => 'Die Änderungen an der Konfiguration wurde gespeichert!',
  'SAVE_SUCCESS_PERMISSIONS' => 'Die Änderungen an den Berechtigungen wurde gespeichert!',
  'SAVE_SUCCESS_RESETPROFILE' => 'Die Benutzereinstellungen wurden auf die Standardwerte zurückgesetzt!',
  'SAVE_SUCCESS_SMILEY' => 'Der Smiley wurde gespeichert!',
  'SAVE_SUCCESS_TEMPLATE' => 'Das Template {{filename}} wurde gespeichert!<br>',
  'SAVE_SUCCESS_UPLOADAUTHORIMG' => 'Der Avatar wurde hochgeladen!',
  'SAVE_SUCCESS_UPLOADMODULE' => 'Die Modul-Paketdatei wurde hochgeladen!',
  'SAVE_SUCCESS_UPLOADPHP' => 'Die Dateien wurden hochgeladen!<br>{{filenames}}',
  'SAVE_SUCCESS_UPLOADTPLFILE' => 'Die Vorlage wurde hochgeladen!',
  'SAVE_SUCCESS_USER_DISABLE' => 'Der Benutzer wurde deaktiviert!',
  'SAVE_SUCCESS_USER_ENABLE' => 'Der Benutzer wurde aktiviert!',
  'SAVE_SUCCESS_WORDBAN' => 'Der Begriff wurde gespeichert!',
  'SEARCH_ERROR' => 'Die Suche konnte nicht ausgeführt werden, da die Filterbedingungen fehlerhaft sind. Bitte überprüfe diese nochmals auf fehlende Verknüpfungen usw.',
  'SEARCH_WAITMSG' => 'Bitte warte 10 Sekunden, bevor du einen neuen Suchvorgang durchführst.',
  'SELECT_ITEMS_MSG' => 'Bitte wähle Elemente oder eine Aktion aus!',
  'SESSION_TIMEOUT' => 'Es wurde festgestellt, dass deine aktuelle Session abgelaufen ist. Willst du zur Login-Seite gehen? (wähle "Nein" um auf der aktuellen Seite zu bleiben)',
  'SUCCESS_FILES_NEWTHUMBS' => 'Neue Thumbnails wurden erzeugt!<br>{{filenames}}',
  'SYSCHECK_COMPLETE' => 'Vollständige Systemprüfung',
  'SYSCHECK_FOLDER_BACKUP' => 'Backup-Ordner',
  'SYSCHECK_FOLDER_CACHE' => 'Cache-Ordner',
  'SYSCHECK_FOLDER_CONFIG' => 'Config-Ordner',
  'SYSCHECK_FOLDER_DATA' => 'Data-Ordner',
  'SYSCHECK_FOLDER_DBDUMP' => 'Datenbank-Backup-Ordner',
  'SYSCHECK_FOLDER_DBSTRUCT' => 'Ordner für Datenbankstrukturdateien',
  'SYSCHECK_FOLDER_DRAFTS' => 'Vorlagen-Ordner',
  'SYSCHECK_FOLDER_FILEMANAGER' => 'Dateimanager-Temp-Ordner',
  'SYSCHECK_FOLDER_LOGS' => 'Protokolle-Ordner',
  'SYSCHECK_FOLDER_MODULES' => 'Module-Ordner',
  'SYSCHECK_FOLDER_NKORG_POLLS' => 'Umfrage-Templates',
  'SYSCHECK_FOLDER_OPTIONS' => 'Optionen-Ordner',
  'SYSCHECK_FOLDER_PROFILES' => 'Profil-Ordner-Struktur',
  'SYSCHECK_FOLDER_SHARE' => 'Share-Button-Ordner',
  'SYSCHECK_FOLDER_SMILEYS' => 'Smiley-Ordner',
  'SYSCHECK_FOLDER_STYLES' => 'Template-Ordner',
  'SYSCHECK_FOLDER_TEMP' => 'Temporäre Dateien Order',
  'SYSCHECK_FOLDER_UPLOADS' => 'Upload-Ordner',
  'SYSTEM_CHECK' => '{{icon="medkit"}} Systemprüfung',
  'SYSTEM_CHECK_CONNECT' => 'Verbindung zu anderen Servern herstellen',
  'SYSTEM_HL_OPTIONS_ARTICLES' => 'Artikel',
  'SYSTEM_HL_OPTIONS_EDITOR' => 'Editor & Dateimanager',
  'SYSTEM_HL_OPTIONS_GENERAL' => 'Allgemein',
  'SYSTEM_HL_OPTIONS_SECURITY' => 'Sicherheit & Wartung',
  'SYSTEM_HL_OPTIONS_SYSCHECK' => 'Systemprüfung',
  'SYSTEM_HL_OPTIONS_TWITTER' => 'Twitter-Verbindung',
  'SYSTEM_OPTIONS_ACPARTICLES_LIMIT' => 'Anzahl Elemente pro Seite im ACP',
  'SYSTEM_OPTIONS_ACTIVECOMMENTTEMPLATE' => 'Kommentar-Template',
  'SYSTEM_OPTIONS_ACTIVENEWSTEMPLATE' => 'Template für Artikel-Liste',
  'SYSTEM_OPTIONS_ACTIVENEWSTEMPLATESINGLE' => 'Template für einzelnen Artikel',
  'SYSTEM_OPTIONS_ANTISPAMANSWER' => 'Antwort auf Captcha-Frage',
  'SYSTEM_OPTIONS_ANTISPAMQUESTION' => 'Captcha-Frage',
  'SYSTEM_OPTIONS_ARCHIVE_LINK' => 'Archiv-Link anzeigen',
  'SYSTEM_OPTIONS_BACKDROP_IMAGE' => 'Hintergrundbild',
  'SYSTEM_OPTIONS_CACHETIMEOUT' => 'Zeit bis zum Cache-Timeout',
  'SYSTEM_OPTIONS_CAPTCHASETTING' => 'Captcha-Einstellungen',
  'SYSTEM_OPTIONS_COMMENTEMAIL' => 'E-Mail-Adresse erforderlich',
  'SYSTEM_OPTIONS_COMMENTFORMTEMPLATE' => 'Kommentar-Formular-Template',
  'SYSTEM_OPTIONS_COMMENT_APPROVE' => 'Kommentar-Freigabe erforderlich',
  'SYSTEM_OPTIONS_COMMENT_DEFAULT_ACTIVE' => 'Kommentare standardmäßig für Artikel aktivieren',
  'SYSTEM_OPTIONS_COMMENT_ENABLED_GLOBAL' => 'Kommentar-System ist aktiv',
  'SYSTEM_OPTIONS_COMMENT_MARKSPAM_PASTCHECK' => 'Automatische Spam-Markierung',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY' => 'Kommentar-Benachrichtigung an',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY_ALL' => 'globale E-Mail-Adresse und Autor',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY_AUTHOR' => 'nur Autor',
  'SYSTEM_OPTIONS_COMMENT_NOTIFY_GLOBAL' => 'globale E-Mail-Adresse',
  'SYSTEM_OPTIONS_COMMENT_PRIVACYOPTIN' => 'Zustimmung zur Datenschutz-Erklärung erforderlich',
  'SYSTEM_OPTIONS_CRONJOBS' => 'Asynchrone Cronjob-Ausführung inaktiv',
  'SYSTEM_OPTIONS_DARKMODE' => 'Dunkles Design verwenden',
  'SYSTEM_OPTIONS_DATETIMEMASK' => 'Datum- und Zeitanzeige',
  'SYSTEM_OPTIONS_DATETIMEMASK_HELP' => 'Syntax entspricht date()-Funktion von PHP',
  'SYSTEM_OPTIONS_EMAIL_ACTIVE' => 'Prüfung der Zugangsdaten war erfolgreich. E-Mail-Versand erfolgt via SMTP.',
  'SYSTEM_OPTIONS_EMAIL_AUTHTYPE' => 'Authentifizierungsart',
  'SYSTEM_OPTIONS_EMAIL_CHECK' => 'SMTP-Verbindung prüfen',
  'SYSTEM_OPTIONS_EMAIL_ENABLED' => 'E-Mails via SMTP versenden',
  'SYSTEM_OPTIONS_EMAIL_ENCRYPTED' => 'SMTP-Verschlüsselung',
  'SYSTEM_OPTIONS_EMAIL_OAUTH' => 'OAuth-Authentifizierung durchführen',
  'SYSTEM_OPTIONS_EMAIL_PASSWORD' => 'SMTP-Passwort',
  'SYSTEM_OPTIONS_EMAIL_PORT' => 'SMTP-Server-Port',
  'SYSTEM_OPTIONS_EMAIL_SERVER' => 'SMTP-Server-Adresse',
  'SYSTEM_OPTIONS_EMAIL_USERNAME' => 'SMTP-Benutzername',
  'SYSTEM_OPTIONS_EXTENDED_DEVUPDATES' => 'Entwickler-Versionen bei Update-Check anzeigen',
  'SYSTEM_OPTIONS_EXTENDED_EMAILSUBMISSION' => 'E-Mail-Versand',
  'SYSTEM_OPTIONS_EXTENDED_EMAILUPDATES' => 'E-Mail-Benachrichtigung, wenn Updates verfügbar',
  'SYSTEM_OPTIONS_EXTENDED_UPDATES' => 'Update-Einstellungen',
  'SYSTEM_OPTIONS_EXTENDED_UPDATESMANCHK' => 'Prüfintervall, ohne externe Server-Verbindungen',
  'SYSTEM_OPTIONS_FILEMANAGER_LIMIT' => 'Anzahl Bilder pro Seite',
  'SYSTEM_OPTIONS_FILEMANAGER_VIEW' => 'Dateimanager-Ansicht',
  'SYSTEM_OPTIONS_FILEMANAGER_VIEWCARDS' => 'Karten',
  'SYSTEM_OPTIONS_FILEMANAGER_VIEWLIST' => 'Liste',
  'SYSTEM_OPTIONS_FLOODPROTECTION' => 'Zeitsperre zwischen zwei Kommentaren',
  'SYSTEM_OPTIONS_INCLUDEJQUERY' => 'jQuery Bibliothek in Frontend laden',
  'SYSTEM_OPTIONS_INCLUDEJQUERY_YES' => 'Wähle &quot;ja&quot;, wenn du jQuery noch nicht anderweitig in deiner Seite eingebunden hast.',
  'SYSTEM_OPTIONS_LANG' => 'Sprache',
  'SYSTEM_OPTIONS_LATESTNEWSTEMPLATE' => '&quot;Lastest News&quot; Template',
  'SYSTEM_OPTIONS_LOGIN_MAXATTEMPTS' => 'Anzahl Login-Versuche vor temporärer Sperre',
  'SYSTEM_OPTIONS_LOGIN_TWOFACTORAUTH' => 'Zwei-Faktor-Authentifizierung',
  'SYSTEM_OPTIONS_MAINTENANCE' => 'Wartungsmodus aktiv',
  'SYSTEM_OPTIONS_NEWSSHARECOUNT' => 'Geteilte Artikel über Share-Buttons zählen',
  'SYSTEM_OPTIONS_NEWSSHOWLIMIT' => 'Anzahl Artikel pro öffentlicher Seite',
  'SYSTEM_OPTIONS_NEWSSHOWMAXIMGSIZEHEIGHT' => 'Höhe in Pixel',
  'SYSTEM_OPTIONS_NEWSSHOWMAXIMGSIZEWIDTH' => 'Breite in Pixel',
  'SYSTEM_OPTIONS_NEWSSHOWSHARELINKS' => 'Share-Buttons anzeigen',
  'SYSTEM_OPTIONS_NEWS_ARCHIVELIMIT' => 'Artikel in Archiv anzeigen ab',
  'SYSTEM_OPTIONS_NEWS_ARCHIVELIMIT_EMPTY' => 'Leer entspricht keinem Limit',
  'SYSTEM_OPTIONS_NEWS_BYAUTHOR' => 'Autor',
  'SYSTEM_OPTIONS_NEWS_BYEDITEDTIME' => 'Letzter Änderung',
  'SYSTEM_OPTIONS_NEWS_BYINTERNALID' => 'Interner ID',
  'SYSTEM_OPTIONS_NEWS_BYWRITTENTIME' => 'Veröffentlichung',
  'SYSTEM_OPTIONS_NEWS_EDITOR' => 'Editor auswählen',
  'SYSTEM_OPTIONS_NEWS_EDITOR_CLASSIC' => 'CodeMirror',
  'SYSTEM_OPTIONS_NEWS_EDITOR_CSS' => 'CSS-Klassen im Editor',
  'SYSTEM_OPTIONS_NEWS_EDITOR_FONTSIZE' => 'Standard-Schriftgröße im Editor',
  'SYSTEM_OPTIONS_NEWS_EDITOR_SETTINGS' => 'Editor-Einstellungen',
  'SYSTEM_OPTIONS_NEWS_EDITOR_TINYMCE5' => 'TinyMCE 5',
  'SYSTEM_OPTIONS_NEWS_ENABLEFEED' => 'RSS-Feed ist aktiv',
  'SYSTEM_OPTIONS_NEWS_ORDERASC' => 'Aufsteigend',
  'SYSTEM_OPTIONS_NEWS_ORDERDESC' => 'Absteigend',
  'SYSTEM_OPTIONS_NEWS_REVISIONS_LIMIT' => 'Alte Revisionen löschen, wenn älter als',
  'SYSTEM_OPTIONS_NEWS_SORTING' => 'Artikel sortieren nach',
  'SYSTEM_OPTIONS_NEWS_SORTING_ORDER' => 'Sortierung ist',
  'SYSTEM_OPTIONS_NEWS_SOURCESLIST' => 'Quellenverzeichnis-Einträge',
  'SYSTEM_OPTIONS_NEWS_SUBFOLDERS' => 'Dateien beim Upload in Unterordner organisieren',
  'SYSTEM_OPTIONS_NEWS_URLREWRITING' => 'URL-Rewriting für Artikellinks aktivieren',
  'SYSTEM_OPTIONS_REVISIONS_ENABLED' => 'Revisionen aktivieren',
  'SYSTEM_OPTIONS_SESSIONLENGHT' => 'Maximale Länge einer Admin-Sitzung',
  'SYSTEM_OPTIONS_STYLESHEET' => 'Pfad zu deiner CSS-Datei',
  'SYSTEM_OPTIONS_SYSCHECK_CACHE' => 'Cache-Backend',
  'SYSTEM_OPTIONS_SYSCHECK_CACHE_FSBACKEND' => 'Dateisystem',
  'SYSTEM_OPTIONS_SYSCHECK_CACHE_MEMCACHEBACKEND' => 'Memcache (experimentell)',
  'SYSTEM_OPTIONS_SYSCHECK_CURRENT' => 'Aktuell',
  'SYSTEM_OPTIONS_SYSCHECK_DBDRV_ACTIVE' => 'Aktiver Datenbanktreiber',
  'SYSTEM_OPTIONS_SYSCHECK_DBDRV_MYSQL' => 'MySQL/ MariaDB Datenbanktreiber verfügbar',
  'SYSTEM_OPTIONS_SYSCHECK_DBDRV_PGSQL' => 'Postgres Datenbanktreiber verfügbar',
  'SYSTEM_OPTIONS_SYSCHECK_DBVERSION' => 'Version des Datenbanksystems >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_FPCMVERSION' => 'FanPress CM Version = {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_HTTPS' => 'HTTPS ist aktiv',
  'SYSTEM_OPTIONS_SYSCHECK_MEMCACHE' => 'Memcached aktiv',
  'SYSTEM_OPTIONS_SYSCHECK_OPCACHE' => 'OPcache aktiv',
  'SYSTEM_OPTIONS_SYSCHECK_PHPMAXEXECTIME' => 'Maximale Ausführungszeit für PHP >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_PHPMEMLIMIT' => 'PHP Speicherlimit >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_PHPVERSION' => 'PHP Version >= {{value}}',
  'SYSTEM_OPTIONS_SYSCHECK_SUBMITSTATS' => 'Statistische Daten übermitteln',
  'SYSTEM_OPTIONS_TIMEZONE' => 'Zeitzone',
  'SYSTEM_OPTIONS_TRASH_CLEANUP_DAYS' => 'Vorhaltezeit für gelöschte Elemente',
  'SYSTEM_OPTIONS_TWITTER_ACTIVE' => 'Twitter-Verbindung ist aktiv! Verbunden mit Benutzer "{{screenname}}".',
  'SYSTEM_OPTIONS_TWITTER_CONNECT' => 'API-Schlüssel bzw. Token anfordern',
  'SYSTEM_OPTIONS_TWITTER_CONSTATE' => 'Verbindungsstatus',
  'SYSTEM_OPTIONS_TWITTER_CONSUMER_KEY' => 'Consumer Key (API Key)',
  'SYSTEM_OPTIONS_TWITTER_CONSUMER_SECRET' => 'Consumer Secret (API Secret)',
  'SYSTEM_OPTIONS_TWITTER_CREDENTIALS' => 'Zugangsdaten',
  'SYSTEM_OPTIONS_TWITTER_DISCONNECT' => 'Verbindung löschen',
  'SYSTEM_OPTIONS_TWITTER_EVENTCREATE' => 'Veröffentlichen',
  'SYSTEM_OPTIONS_TWITTER_EVENTS' => 'Tweet zu Artikel erzeugen beim',
  'SYSTEM_OPTIONS_TWITTER_EVENTTIMELINE' => 'Tweet-Timeline abrufen',
  'SYSTEM_OPTIONS_TWITTER_EVENTUPDATE' => 'Aktualisieren',
  'SYSTEM_OPTIONS_TWITTER_USER_SECRET' => 'Access Token Secret',
  'SYSTEM_OPTIONS_TWITTER_USER_TOKEN' => 'Access Token',
  'SYSTEM_OPTIONS_URL' => 'Basis-URL für Artikellinks',
  'SYSTEM_OPTIONS_USEMODE' => 'Verwendung per',
  'SYSTEM_OPTIONS_USEMODE_IFRAME' => 'iframe',
  'SYSTEM_OPTIONS_USEMODE_PHPINCLUDE' => 'phpinclude',
  'SYSTEM_OPTIONS_USERS_PASSCHECK' => 'Benutzer-Passwörter gegen den Dienst haveibeenpwned.com/passwords prüfen',
  'SYSTEM_STATS' => '{{icon="chart-bar"}} Statistiken',
  'SYSTEM_STATS_ARTICLES_ACTIVE' => 'Artikel aktiv',
  'SYSTEM_STATS_ARTICLES_ALL' => 'Artikel gesamt',
  'SYSTEM_STATS_ARTICLES_APPROVAL' => 'freizugebende Artikel',
  'SYSTEM_STATS_ARTICLES_ARCHIVE' => 'Artikel archiviert',
  'SYSTEM_STATS_ARTICLES_DRAFT' => 'Artikel-Entwürfe',
  'SYSTEM_STATS_ARTICLES_POSTPONED' => 'geplante Artikel',
  'SYSTEM_STATS_CACHE_SIZE' => 'Größe des Cache',
  'SYSTEM_STATS_CATEGORIES' => 'Kategorien',
  'SYSTEM_STATS_COMMENTS_ALL' => 'Kommentare gesamt',
  'SYSTEM_STATS_COMMENTS_PRIVATE' => 'Kommentare privat',
  'SYSTEM_STATS_COMMENTS_SPAM' => 'Spam-Kommentare',
  'SYSTEM_STATS_COMMENTS_UNAPPR' => 'Kommentare nicht genehmigt',
  'SYSTEM_STATS_TRASHCOUNT' => 'Gelöschte Elemente',
  'SYSTEM_STATS_UPLOAD_COUNT' => 'hochgeladene Dateien',
  'SYSTEM_STATS_UPLOAD_SIZE' => 'Größe des Upload-Ordners',
  'SYSTEM_STATS_USERS' => 'Benutzer (davon aktiv)',
  'SYSTEM_UPDATE' => '{{icon="sync"}} Verfügbare Updates',
  'TEMPLATE_ARTICLE_ARTICLEIMAGE' => 'Artikelbild',
  'TEMPLATE_ARTICLE_AUTHOR' => 'Artikel-Autor',
  'TEMPLATE_ARTICLE_AUTHORAVATAR' => 'Avatar des Artikel-Autors',
  'TEMPLATE_ARTICLE_AUTHOREMAIL' => 'Artikel-Autor mit verlinkter E-Mail-Adresse',
  'TEMPLATE_ARTICLE_AUTHORINFOTEXT' => 'kurzer Text mit Infos zum Artikel-Autor',
  'TEMPLATE_ARTICLE_CATEGORYICONS' => 'Kategorie-Icons',
  'TEMPLATE_ARTICLE_CATEGORYTEXTS' => 'Kategorien',
  'TEMPLATE_ARTICLE_CHANGEDATE' => 'Datum + Zeit der letzten Änderung',
  'TEMPLATE_ARTICLE_CHANGEUSER' => 'Benutzer der letzten Änderung',
  'TEMPLATE_ARTICLE_COMMENTCOUNT' => 'Kommentar-Anzahl',
  'TEMPLATE_ARTICLE_COMMENTLINK' => 'Kommentar-Link',
  'TEMPLATE_ARTICLE_DATE' => 'Datum + Zeit',
  'TEMPLATE_ARTICLE_HEADLINE' => 'Überschrift',
  'TEMPLATE_ARTICLE_OLDARTICLE' => 'Hinweis auf alte Artikel',
  'TEMPLATE_ARTICLE_PERMALINK' => 'Artikellink',
  'TEMPLATE_ARTICLE_SHAREBUTTONS' => 'Share-Buttons',
  'TEMPLATE_ARTICLE_SHORTLINK' => 'Kurzlink',
  'TEMPLATE_ARTICLE_SOURCES' => 'Quellenverzeichnis',
  'TEMPLATE_ARTICLE_STATUSPINNED' => 'Hinweis, dass News gepinnt ist',
  'TEMPLATE_ARTICLE_TEXT' => 'Artikeltext',
  'TEMPLATE_ARTICLE_TEXTSHORT' => 'Kurzversion des Artikeltextes, Verwendung von {{pagebreakVar}} möglich',
  'TEMPLATE_ATTRIBUTES' => 'Verfügbare Attribute',
  'TEMPLATE_COMMMENTFORM_EMAILDESCRIPTION' => 'Feld-Beschreibung "E-Mail"',
  'TEMPLATE_COMMMENTFORM_EMAILFIELD' => 'Feld "E-Mail"',
  'TEMPLATE_COMMMENTFORM_FORMHEADLINE' => 'Kommentar-Formular-Überschrift',
  'TEMPLATE_COMMMENTFORM_NAMEDESCRIPTION' => 'Feld-Beschreibung "Name"',
  'TEMPLATE_COMMMENTFORM_NAMEFIELD' => 'Feld "Name"',
  'TEMPLATE_COMMMENTFORM_PRIVACYCOMFIRMATION' => 'Checkbox für zusätzliche Datenschutz-Zustimmung',
  'TEMPLATE_COMMMENTFORM_PRIVATECHECKBOX' => 'Checkbox für privaten Kommentar',
  'TEMPLATE_COMMMENTFORM_RESETBUTTON' => 'Zurücksetzen-Button',
  'TEMPLATE_COMMMENTFORM_SMILEYS' => 'Smileys',
  'TEMPLATE_COMMMENTFORM_SMILEYSDESCRIPTION' => '"Smiley"-Beschreibung',
  'TEMPLATE_COMMMENTFORM_SPAMPLUGINFIELD' => 'Anti-Spam-Plugin Antwort-Feld',
  'TEMPLATE_COMMMENTFORM_SPAMPLUGINQUESTION' => 'Anti-Spam-Plugin Frage',
  'TEMPLATE_COMMMENTFORM_SUBMITBUTTON' => 'Senden-Button',
  'TEMPLATE_COMMMENTFORM_SUBMITURL' => 'URL des Kommentar-Formulars <b>(wichtig!)</b>',
  'TEMPLATE_COMMMENTFORM_TAGS' => 'Erlaubte HTML-Tags in Kommentar',
  'TEMPLATE_COMMMENTFORM_TEXTFIELD' => 'Textarea für Kommentar-Text',
  'TEMPLATE_COMMMENTFORM_WEBSITEDESCRIPTION' => 'Feld-Beschreibung "Webseite"',
  'TEMPLATE_COMMMENTFORM_WEBSITEFIELD' => 'Feld "Webseite"',
  'TEMPLATE_COMMMENT_AUTHOR' => 'Kommentar-Autor',
  'TEMPLATE_COMMMENT_DATE' => 'Datum + Zeit',
  'TEMPLATE_COMMMENT_EMAIL' => 'Autor-E-Mail',
  'TEMPLATE_COMMMENT_ID' => 'Kommentar-ID',
  'TEMPLATE_COMMMENT_MENTION' => 'Link um auf Kommentar zu antworten',
  'TEMPLATE_COMMMENT_MENTIONID' => 'ID um <i>{{mention}}:{{/mention}}</i> zu nutzen',
  'TEMPLATE_COMMMENT_NUMBER' => 'Nummer des Kommentars',
  'TEMPLATE_COMMMENT_TEXT' => 'Kommentar-Text',
  'TEMPLATE_COMMMENT_WEBSITE' => 'Webseite des Autors',
  'TEMPLATE_EDITOR' => 'Template-Editor',
  'TEMPLATE_HL_ARTICLES' => 'Artikel-Liste',
  'TEMPLATE_HL_ARTICLE_SINGLE' => 'Artikel-Einzel-Ansicht',
  'TEMPLATE_HL_COMMENTFORM' => 'Kommentar-Formular',
  'TEMPLATE_HL_COMMENTS' => 'Kommentar',
  'TEMPLATE_HL_DRAFTS' => 'Artikel-Vorlagen',
  'TEMPLATE_HL_DRAFTS_EDIT' => 'Artikel-Vorlage bearbeiten',
  'TEMPLATE_HL_LATESTNEWS' => 'Latest News',
  'TEMPLATE_HL_SHAREBUTTONS' => 'Share-Buttons',
  'TEMPLATE_HL_TWEET' => 'Tweet',
  'TEMPLATE_NOT_WRITABLE' => 'Das ausgewählte Template ist nicht beschreibbar, bitte prüfe die Berechtigungen auf dem Server.',
  'TEMPLATE_REPLACEMENTS' => 'Verwendbare Platzhalter',
  'TEMPLATE_SHAREBUTTONS_ARTICLEID' => 'Artikle-ID (für eigene Buttons)',
  'TEMPLATE_SHAREBUTTONS_CREDITS' => 'Credit-Tag für Icons, etc.',
  'TEMPLATE_SHAREBUTTONS_DESCRIPTION' => 'Beschreibung (für eigene Buttons)',
  'TEMPLATE_SHAREBUTTONS_EMAIL' => 'Button für E-Mail',
  'TEMPLATE_SHAREBUTTONS_FACEBOOK' => 'Button für Facebook',
  'TEMPLATE_SHAREBUTTONS_LIKEBUTTON' => 'Button um Beitrag "Gefällt mir" zu vergeben, öffnet keinen externen Dienst. Achtung! Der Button funktioniert nicht, wenn die Option "Geteilte Artikel über Share-Buttons zählen" deaktiviert ist!',
  'TEMPLATE_SHAREBUTTONS_LINK' => 'Ziel-Link (für eigene Buttons)',
  'TEMPLATE_SHAREBUTTONS_PINTEREST' => 'Button für Pinterest',
  'TEMPLATE_SHAREBUTTONS_REDDIT' => 'Button für Reddit',
  'TEMPLATE_SHAREBUTTONS_TELEGRAM' => 'Button für Telegram',
  'TEMPLATE_SHAREBUTTONS_TUMBLR' => 'Button für Tumblr',
  'TEMPLATE_SHAREBUTTONS_TWITTER' => 'Button für Twitter',
  'TEMPLATE_SHAREBUTTONS_WHATSAPP' => 'Button für WhatsApp',
  'UPDATE_MODULECHECK_CURRENT' => 'Alle installierten Module sind <strong>aktuell</strong>!',
  'UPDATE_MODULECHECK_FAILED' => 'Es konnte keine Update-Prüfung für die installierten Module durchgeführt werden!',
  'UPDATE_MODULECHECK_NEW' => 'Für einige Module sind Updates verfügbar. {{btn}}',
  'UPDATE_NOTAUTOCHECK' => 'Es konnte keine automatische Update-Prüfung durchgeführt werden! {{btn}}',
  'UPDATE_VERSIONCECK_FILEDB_ERR' => 'Die Version im Dateisystem und der Datenbank stimmen nicht überein. {{btn}}',
  'UPDATE_VERSIONCECK_FILETXT_ERR' => 'Die Datei <em>/data/config/files.txt</em> wurde nicht gefunden. Dies sollte nicht passieren und kann zu unvorhergesehenem Verhalten führen.',
  'UPDATE_VERSIONCECK_FILETXT_ERR2' => 'Die Datei /config/files.txt wurde für dieses Modul nicht gefunden. Dies sollte nicht passieren und kann zu unvorhergesehenem Verhalten führen.',
  'UPDATE_VERSIONCHECK_CURRENT' => 'Deine Version von FanPress CM ist <strong>aktuell</strong>!',
  'UPDATE_VERSIONCHECK_NEW' => 'FanPress CM Version <i>{{version}}</i> ist verfügbar! {{btn}}',
  'UPDATE_VERSIONCHECK_NOTES' => 'Release-Notes und weitere Infos zu System- und Modul-Updates findest du in den aktuellen FanPress CM News.',
  'UPDATE_WRITEERROR' => 'Einige Dateien im Dateisystem sind nicht beschreibbar und können daher nicht ersetzt werden. Prüfe die Rechte der Dateien via FTP, eine Liste findest du im System-Log.',
  'USERS_ADD' => 'Benutzer anlegen',
  'USERS_ARTICLES_SELECT' => 'Bitte wähle aus, was mit Artikeln dieses Benutzers passieren soll',
  'USERS_ARTICLES_USER' => 'Benutzer auswählen',
  'USERS_ARTICLE_COUNT' => 'Artikel-Anzahl',
  'USERS_AUTHTOKEN_ACTIVE' => 'Die Zwei-Faktor-Authentifizierung ist aktiv.',
  'USERS_AUTHTOKEN_SAVE' => 'Zahlencode zur Aktivierung',
  'USERS_AVATAR' => 'Avatar',
  'USERS_BIOGRAPHY' => 'Biografie / Sonstiges',
  'USERS_DISABLED' => 'Benutzer wurde deaktiviert',
  'USERS_DISPLAYNAME' => 'Angezeigter Name',
  'USERS_EDIT' => 'Benutzer bearbeiten',
  'USERS_EDIT_PERMISSION' => 'Berechtigungen bearbeiten: {{rollname}}',
  'USERS_LIST' => 'Benutzer',
  'USERS_LIST_ROLLS' => 'Rollen',
  'USERS_META_OPTIONS' => 'Benutzereinstellungen',
  'USERS_META_RESET_DASHBOARD' => 'Container-Positionen zurücksetzen',
  'USERS_PASSGEN' => 'Passwort generieren',
  'USERS_PASSWORD_CONFIRM' => 'Passwort bestätigen',
  'USERS_PASSWORD_SENDUSERINFO' => 'Benutzer über neues Passwort informieren',
  'USERS_REGISTEREDTIME' => 'Registriert am',
  'USERS_REQUIREMENTS' => 'Passwort muss min. 6 Zeichen sowie Groß- und Kleinbuchstaben und Ziffern enthalten.',
  'USERS_ROLL' => 'Rolle',
  'USERS_ROLLS_CODEX' => 'Codex',
  'USERS_ROLLS_NAME' => 'Rollenname',
  'USERS_ROLLS_PERMISSIONS' => 'Rechte der Rolle bearbeiten',
  'USERS_ROLL_ADD' => 'Rolle anlegen',
  'USERS_ROLL_EDIT' => 'Rolle bearbeiten',
  'USERS_SENDUSERINFO' => 'Benutzer informieren',
  'USERS_STATS_ARTICLE' => 'Artikel-Statistik',
  'USERS_SYSTEMUSER' => 'FPCM-System',
  'VERSION' => 'Version',
  'VIEW_NOT_FOUND' => 'Die View {{viewname}} wurde nicht gefunden!',
  'WELCOME_CONTENT' => 'Du befindest dich im Dashboard von FanPress CM, dem News-System speziell für Fanseiten.<br>Über die Navigation links kannst du in die verschiedenen Bereiche gelangen.<br><br>Nachfolgend findest du einige Statistiken und weitere Informationen zum aktuellen System.',
  'WELCOME_HEADLINE' => '{{icon="user"}} Willkommen {{username}}!',
  'WORDBAN_ADD' => 'Begriff hinzufügen',
  'WORDBAN_APPROVA_COMMENT' => 'Kommentar muss freigeschaltet werden',
  'WORDBAN_APPROVE_ARTICLE' => 'Artikel muss überprüft werden',
  'WORDBAN_EDIT' => 'Begriff bearbeiten',
  'WORDBAN_FORM' => 'Einstellungen für diesen Text',
  'WORDBAN_NAME' => 'Begriff',
  'WORDBAN_REPLACEMENT_TEXT' => 'Ersetzung',
  'WORDBAN_REPLACETEXT' => 'Text ersetzen',
);
